/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.util.Terser;

public class DeepCopy {
    public static void copy(Type from, Type to) throws DataTypeException {
        int i = 1;
        while (i <= Terser.numComponents(from)) {
            int j = 1;
            while (j <= Terser.numSubComponents(from, i)) {
                String val = Terser.getPrimitive(from, i, j).getValue();
                Terser.getPrimitive(to, i, j).setValue(val);
                ++j;
            }
            ++i;
        }
    }

    public static void copy(Segment from, Segment to) throws HL7Exception {
        int n = from.numFields();
        int i = 1;
        while (i <= n) {
            Type[] reps = from.getField(i);
            int j = 0;
            while (j < reps.length) {
                DeepCopy.copy(reps[j], to.getField(i, j));
                ++j;
            }
            ++i;
        }
    }
}

