/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v3.sourcegen;

import ca.uhn.hl7v3.sourcegen.ComponentDefinition;
import ca.uhn.hl7v3.sourcegen.DataTypeDefinition;
import ca.uhn.hl7v3.sourcegen.SourceGenerator;

public class DataTypeGenerator {
    public String makeDataType(DataTypeDefinition type) {
        String code = null;
        if (type.getType().equalsIgnoreCase("Primitive")) {
            code = this.makePrimitive(type);
        } else if (type.getType().equalsIgnoreCase("Composite")) {
            code = this.makeComposite(type);
        } else if (type.getType().equalsIgnoreCase("Generic")) {
            code = this.makeGeneric(type);
        } else if (type.getType().equalsIgnoreCase("Instance")) {
            code = this.makeInstance(type);
        }
        return code;
    }

    public String makePrimitive(DataTypeDefinition primitiveType) {
        StringBuffer code = new StringBuffer();
        code.append("package ");
        code.append(SourceGenerator.getRIMDataTypePackage());
        code.append("; \r\n\r\n");
        code.append(SourceGenerator.makeJavaDocComment(primitiveType.getDescription(), 0));
        code.append("public class ");
        code.append(primitiveType.getName());
        code.append(" extends ");
        if (primitiveType.getSuperClass() != null) {
            code.append(primitiveType.getSuperClass());
        } else {
            code.append("Primitive");
        }
        code.append(" { \r\n\r\n");
        code.append("} \r\n");
        return code.toString();
    }

    public String makeComposite(DataTypeDefinition compositeType) {
        StringBuffer code = new StringBuffer();
        code.append("package ");
        code.append(SourceGenerator.getRIMDataTypePackage());
        code.append("; \r\n\r\n");
        code.append(SourceGenerator.makeJavaDocComment(compositeType.getDescription(), 0));
        code.append("public class ");
        code.append(compositeType.getName());
        code.append(" extends ");
        if (compositeType.getSuperClass() != null) {
            code.append(compositeType.getSuperClass());
        } else {
            code.append("Composite");
        }
        code.append(" { \r\n\r\n");
        ComponentDefinition[] components = compositeType.getComponents();
        int i = 0;
        while (i < components.length) {
            code.append(this.makeAttributeDeclaration(components[i]));
            ++i;
        }
        code.append("\r\n");
        i = 0;
        while (i < components.length) {
            code.append(this.makeSetter(components[i]));
            code.append(this.makeGetter(components[i]));
            code.append("\r\n");
            ++i;
        }
        code.append("} \r\n");
        return code.toString();
    }

    public String makeGeneric(DataTypeDefinition genericType) {
        StringBuffer code = new StringBuffer();
        code.append("package ");
        code.append(SourceGenerator.getRIMDataTypePackage());
        code.append("; \r\n\r\n");
        code.append(SourceGenerator.makeJavaDocComment(genericType.getDescription(), 0));
        code.append("public class ");
        code.append(genericType.getName());
        code.append(" extends ");
        if (genericType.getSuperClass() != null) {
            code.append(genericType.getSuperClass());
        } else {
            code.append("Generic");
        }
        code.append(" { \r\n\r\n");
        code.append("} \r\n");
        return code.toString();
    }

    public String makeInstance(DataTypeDefinition instanceType) {
        StringBuffer code = new StringBuffer();
        code.append("package ");
        code.append(SourceGenerator.getRIMDataTypePackage());
        code.append("; \r\n\r\n");
        code.append(SourceGenerator.makeJavaDocComment(instanceType.getDescription(), 0));
        code.append("public class ");
        code.append(DataTypeDefinition.mapInstanceName(instanceType.getName()));
        code.append(" extends ");
        code.append(DataTypeDefinition.getAssociatedGeneric(instanceType.getName()));
        code.append(" { \r\n");
        code.append("} \r\n");
        return code.toString();
    }

    public String makeAttributeDeclaration(ComponentDefinition component) {
        StringBuffer code = new StringBuffer();
        code.append("    public ");
        code.append(component.getDataType());
        code.append(" ");
        code.append(component.getName());
        code.append("; \r\n");
        return code.toString();
    }

    public String makeGetter(ComponentDefinition component) {
        StringBuffer code = new StringBuffer();
        code.append(SourceGenerator.makeJavaDocComment(component.getDescription(), 4));
        code.append("    public ");
        code.append(component.getDataType());
        code.append(" get");
        code.append(DataTypeGenerator.capitalize(component.getName()));
        code.append("() { \r\n");
        code.append("        return this.");
        code.append(component.getName());
        code.append("; \r\n");
        code.append("    } \r\n");
        return code.toString();
    }

    public String makeSetter(ComponentDefinition component) {
        StringBuffer code = new StringBuffer();
        code.append(SourceGenerator.makeJavaDocComment(component.getDescription(), 4));
        code.append("    public void set");
        code.append(DataTypeGenerator.capitalize(component.getName()));
        code.append("(");
        code.append(component.getDataType());
        code.append(" ");
        code.append(component.getName());
        code.append(") { \r\n");
        code.append("        this.");
        code.append(component.getName());
        code.append(" = ");
        code.append(component.getName());
        code.append("; \r\n");
        code.append("    } \r\n");
        return code.toString();
    }

    private static String capitalize(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null && s.length() > 0) {
            result.append(s.substring(0, 1).toUpperCase());
            if (s.length() > 1) {
                result.append(s.substring(1, s.length()));
            }
        }
        return result.toString();
    }
}

