/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_ruleset;

import co.elastic.clients.elasticsearch.query_ruleset.QueryRule;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class QueryRuleset
implements JsonpSerializable {
    private final String rulesetId;
    private final List<QueryRule> rules;
    public static final JsonpDeserializer<QueryRuleset> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRuleset::setupQueryRulesetDeserializer);

    protected QueryRuleset(AbstractBuilder<?> builder) {
        this.rulesetId = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).rulesetId, this, "rulesetId");
        this.rules = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).rules, (Object)this, "rules");
    }

    public static QueryRuleset queryRulesetOf(Function<Builder, ObjectBuilder<QueryRuleset>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    public final List<QueryRule> rules() {
        return this.rules;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("ruleset_id");
        generator.write(this.rulesetId);
        if (ApiTypeHelper.isDefined(this.rules)) {
            generator.writeKey("rules");
            generator.writeStartArray();
            for (QueryRule item0 : this.rules) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupQueryRulesetDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::rulesetId, JsonpDeserializer.stringDeserializer(), "ruleset_id");
        op.add(AbstractBuilder::rules, JsonpDeserializer.arrayDeserializer(QueryRule._DESERIALIZER), "rules");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String rulesetId;
        private List<QueryRule> rules;

        public final BuilderT rulesetId(String value) {
            this.rulesetId = value;
            return (BuilderT)this.self();
        }

        public final BuilderT rules(List<QueryRule> list) {
            this.rules = AbstractBuilder._listAddAll(this.rules, list);
            return (BuilderT)this.self();
        }

        public final BuilderT rules(QueryRule value, QueryRule ... values) {
            this.rules = AbstractBuilder._listAdd(this.rules, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT rules(Function<QueryRule.Builder, ObjectBuilder<QueryRule>> fn) {
            return this.rules(fn.apply(new QueryRule.Builder()).build(), new QueryRule[0]);
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<QueryRuleset> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRuleset build() {
            this._checkSingleUse();
            return new QueryRuleset(this);
        }
    }
}

