/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.xpack.XpackInfoRequest;
import co.elastic.clients.elasticsearch.xpack.XpackInfoResponse;
import co.elastic.clients.elasticsearch.xpack.XpackUsageRequest;
import co.elastic.clients.elasticsearch.xpack.XpackUsageResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchXpackClient
extends ApiClient<ElasticsearchTransport, ElasticsearchXpackClient> {
    public ElasticsearchXpackClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchXpackClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchXpackClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchXpackClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public XpackInfoResponse info(XpackInfoRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)XpackInfoRequest._ENDPOINT;
        return (XpackInfoResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final XpackInfoResponse info(Function<XpackInfoRequest.Builder, ObjectBuilder<XpackInfoRequest>> fn) throws IOException, ElasticsearchException {
        return this.info(fn.apply(new XpackInfoRequest.Builder()).build());
    }

    public XpackInfoResponse info() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequest(new XpackInfoRequest.Builder().build(), XpackInfoRequest._ENDPOINT, this.transportOptions);
    }

    public XpackUsageResponse usage(XpackUsageRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)XpackUsageRequest._ENDPOINT;
        return (XpackUsageResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final XpackUsageResponse usage(Function<XpackUsageRequest.Builder, ObjectBuilder<XpackUsageRequest>> fn) throws IOException, ElasticsearchException {
        return this.usage(fn.apply(new XpackUsageRequest.Builder()).build());
    }

    public XpackUsageResponse usage() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequest(new XpackUsageRequest.Builder().build(), XpackUsageRequest._ENDPOINT, this.transportOptions);
    }
}

