/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write;

import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.ExcelColumnProperty;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.metadata.Table;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.POITempFile;
import com.alibaba.excel.util.TypeUtil;
import com.alibaba.excel.util.WorkBookUtil;
import com.alibaba.excel.write.ExcelBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.cglib.beans.BeanMap;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelBuilderImpl
implements ExcelBuilder {
    private WriteContext context;

    public ExcelBuilderImpl(InputStream templateInputStream, OutputStream out, ExcelTypeEnum excelType, boolean needHead) {
        try {
            POITempFile.createPOIFilesDirectory();
            this.context = new WriteContext(templateInputStream, out, excelType, needHead);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addContent(List data, int startRow) {
        Row row;
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        int rowNum = this.context.getCurrentSheet().getLastRowNum();
        if (!(rowNum != 0 || (row = this.context.getCurrentSheet().getRow(0)) != null || this.context.getExcelHeadProperty() != null && this.context.needHead())) {
            rowNum = -1;
        }
        if (rowNum < startRow) {
            rowNum = startRow;
        }
        for (int i = 0; i < data.size(); ++i) {
            int n = i + rowNum + 1;
            this.addOneRowOfDataToExcel(data.get(i), n);
        }
    }

    @Override
    public void addContent(List data, Sheet sheetParam) {
        this.context.currentSheet(sheetParam);
        this.addContent(data, sheetParam.getStartRow());
    }

    @Override
    public void addContent(List data, Sheet sheetParam, Table table) {
        this.context.currentSheet(sheetParam);
        this.context.currentTable(table);
        this.addContent(data, sheetParam.getStartRow());
    }

    @Override
    public void merge(int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cra = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        this.context.getCurrentSheet().addMergedRegion(cra);
    }

    @Override
    public void finish() {
        try {
            this.context.getWorkbook().write(this.context.getOutputStream());
            this.context.getWorkbook().close();
        }
        catch (IOException e) {
            throw new ExcelGenerateException("IO error", e);
        }
    }

    private void addBasicTypeToExcel(List<Object> oneRowData, Row row) {
        if (CollectionUtils.isEmpty(oneRowData)) {
            return;
        }
        for (int i = 0; i < oneRowData.size(); ++i) {
            Object cellValue = oneRowData.get(i);
            WorkBookUtil.createCell(row, i, this.context.getCurrentContentStyle(), cellValue, TypeUtil.isNum(cellValue));
        }
    }

    private void addJavaObjectToExcel(Object oneRowData, Row row) {
        int i = 0;
        BeanMap beanMap = BeanMap.create((Object)oneRowData);
        for (ExcelColumnProperty excelHeadProperty : this.context.getExcelHeadProperty().getColumnPropertyList()) {
            BaseRowModel baseRowModel = (BaseRowModel)oneRowData;
            String cellValue = TypeUtil.getFieldStringValue(beanMap, excelHeadProperty.getField().getName(), excelHeadProperty.getFormat());
            CellStyle cellStyle = baseRowModel.getStyle(i) != null ? baseRowModel.getStyle(i) : this.context.getCurrentContentStyle();
            WorkBookUtil.createCell(row, i, cellStyle, cellValue, TypeUtil.isNum(excelHeadProperty.getField()));
            ++i;
        }
    }

    private void addOneRowOfDataToExcel(Object oneRowData, int n) {
        Row row = WorkBookUtil.createRow(this.context.getCurrentSheet(), n);
        if (oneRowData instanceof List) {
            this.addBasicTypeToExcel((List)oneRowData, row);
        } else {
            this.addJavaObjectToExcel(oneRowData, row);
        }
    }
}

