/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata;

import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.metadata.AbstractCell;
import org.apache.poi.ss.util.CellReference;

public class CellExtra
extends AbstractCell {
    private CellExtraTypeEnum type;
    private String text;
    private Integer firstRowIndex;
    private Integer lastRowIndex;
    private Integer firstColumnIndex;
    private Integer lastColumnIndex;

    public CellExtra(CellExtraTypeEnum type, String text, String range) {
        CellReference first;
        this.type = type;
        this.text = text;
        String[] ranges = range.split(":");
        CellReference last = first = new CellReference(ranges[0]);
        this.firstRowIndex = first.getRow();
        this.firstColumnIndex = first.getCol();
        this.setRowIndex(this.firstRowIndex);
        this.setColumnIndex(this.firstColumnIndex);
        if (ranges.length > 1) {
            last = new CellReference(ranges[1]);
        }
        this.lastRowIndex = last.getRow();
        this.lastColumnIndex = last.getCol();
    }

    public CellExtra(CellExtraTypeEnum type, String text, Integer rowIndex, Integer columnIndex) {
        this(type, text, rowIndex, rowIndex, columnIndex, columnIndex);
    }

    public CellExtra(CellExtraTypeEnum type, String text, Integer firstRowIndex, Integer lastRowIndex, Integer firstColumnIndex, Integer lastColumnIndex) {
        this.setRowIndex(firstRowIndex);
        this.setColumnIndex(firstColumnIndex);
        this.type = type;
        this.text = text;
        this.firstRowIndex = firstRowIndex;
        this.firstColumnIndex = firstColumnIndex;
        this.lastRowIndex = lastRowIndex;
        this.lastColumnIndex = lastColumnIndex;
    }

    public CellExtraTypeEnum getType() {
        return this.type;
    }

    public void setType(CellExtraTypeEnum type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Integer getFirstRowIndex() {
        return this.firstRowIndex;
    }

    public void setFirstRowIndex(Integer firstRowIndex) {
        this.firstRowIndex = firstRowIndex;
    }

    public Integer getFirstColumnIndex() {
        return this.firstColumnIndex;
    }

    public void setFirstColumnIndex(Integer firstColumnIndex) {
        this.firstColumnIndex = firstColumnIndex;
    }

    public Integer getLastRowIndex() {
        return this.lastRowIndex;
    }

    public void setLastRowIndex(Integer lastRowIndex) {
        this.lastRowIndex = lastRowIndex;
    }

    public Integer getLastColumnIndex() {
        return this.lastColumnIndex;
    }

    public void setLastColumnIndex(Integer lastColumnIndex) {
        this.lastColumnIndex = lastColumnIndex;
    }
}

