/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.property;

import com.alibaba.excel.annotation.write.style.ContentFontStyle;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.util.StringUtils;

public class FontProperty {
    private String fontName;
    private Short fontHeightInPoints;
    private Boolean italic;
    private Boolean strikeout;
    private Short color;
    private Short typeOffset;
    private Byte underline;
    private Integer charset;
    private Boolean bold;

    public static FontProperty build(HeadFontStyle headFontStyle) {
        if (headFontStyle == null) {
            return null;
        }
        FontProperty styleProperty = new FontProperty();
        if (StringUtils.isNotBlank(headFontStyle.fontName())) {
            styleProperty.setFontName(headFontStyle.fontName());
        }
        if (headFontStyle.fontHeightInPoints() >= 0) {
            styleProperty.setFontHeightInPoints(headFontStyle.fontHeightInPoints());
        }
        styleProperty.setItalic(headFontStyle.italic().getBooleanValue());
        styleProperty.setStrikeout(headFontStyle.strikeout().getBooleanValue());
        if (headFontStyle.color() >= 0) {
            styleProperty.setColor(headFontStyle.color());
        }
        if (headFontStyle.typeOffset() >= 0) {
            styleProperty.setTypeOffset(headFontStyle.typeOffset());
        }
        if (headFontStyle.underline() >= 0) {
            styleProperty.setUnderline(headFontStyle.underline());
        }
        if (headFontStyle.charset() >= 0) {
            styleProperty.setCharset(headFontStyle.charset());
        }
        styleProperty.setBold(headFontStyle.bold().getBooleanValue());
        return styleProperty;
    }

    public static FontProperty build(ContentFontStyle contentFontStyle) {
        if (contentFontStyle == null) {
            return null;
        }
        FontProperty styleProperty = new FontProperty();
        if (StringUtils.isNotBlank(contentFontStyle.fontName())) {
            styleProperty.setFontName(contentFontStyle.fontName());
        }
        if (contentFontStyle.fontHeightInPoints() >= 0) {
            styleProperty.setFontHeightInPoints(contentFontStyle.fontHeightInPoints());
        }
        styleProperty.setItalic(contentFontStyle.italic().getBooleanValue());
        styleProperty.setStrikeout(contentFontStyle.strikeout().getBooleanValue());
        if (contentFontStyle.color() >= 0) {
            styleProperty.setColor(contentFontStyle.color());
        }
        if (contentFontStyle.typeOffset() >= 0) {
            styleProperty.setTypeOffset(contentFontStyle.typeOffset());
        }
        if (contentFontStyle.underline() >= 0) {
            styleProperty.setUnderline(contentFontStyle.underline());
        }
        if (contentFontStyle.charset() >= 0) {
            styleProperty.setCharset(contentFontStyle.charset());
        }
        styleProperty.setBold(contentFontStyle.bold().getBooleanValue());
        return styleProperty;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Short getFontHeightInPoints() {
        return this.fontHeightInPoints;
    }

    public Boolean getItalic() {
        return this.italic;
    }

    public Boolean getStrikeout() {
        return this.strikeout;
    }

    public Short getColor() {
        return this.color;
    }

    public Short getTypeOffset() {
        return this.typeOffset;
    }

    public Byte getUnderline() {
        return this.underline;
    }

    public Integer getCharset() {
        return this.charset;
    }

    public Boolean getBold() {
        return this.bold;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontHeightInPoints(Short fontHeightInPoints) {
        this.fontHeightInPoints = fontHeightInPoints;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public void setStrikeout(Boolean strikeout) {
        this.strikeout = strikeout;
    }

    public void setColor(Short color) {
        this.color = color;
    }

    public void setTypeOffset(Short typeOffset) {
        this.typeOffset = typeOffset;
    }

    public void setUnderline(Byte underline) {
        this.underline = underline;
    }

    public void setCharset(Integer charset) {
        this.charset = charset;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FontProperty)) {
            return false;
        }
        FontProperty other = (FontProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Short this$fontHeightInPoints = this.getFontHeightInPoints();
        Short other$fontHeightInPoints = other.getFontHeightInPoints();
        if (this$fontHeightInPoints == null ? other$fontHeightInPoints != null : !((Object)this$fontHeightInPoints).equals(other$fontHeightInPoints)) {
            return false;
        }
        Boolean this$italic = this.getItalic();
        Boolean other$italic = other.getItalic();
        if (this$italic == null ? other$italic != null : !((Object)this$italic).equals(other$italic)) {
            return false;
        }
        Boolean this$strikeout = this.getStrikeout();
        Boolean other$strikeout = other.getStrikeout();
        if (this$strikeout == null ? other$strikeout != null : !((Object)this$strikeout).equals(other$strikeout)) {
            return false;
        }
        Short this$color = this.getColor();
        Short other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        Short this$typeOffset = this.getTypeOffset();
        Short other$typeOffset = other.getTypeOffset();
        if (this$typeOffset == null ? other$typeOffset != null : !((Object)this$typeOffset).equals(other$typeOffset)) {
            return false;
        }
        Byte this$underline = this.getUnderline();
        Byte other$underline = other.getUnderline();
        if (this$underline == null ? other$underline != null : !((Object)this$underline).equals(other$underline)) {
            return false;
        }
        Integer this$charset = this.getCharset();
        Integer other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        Boolean this$bold = this.getBold();
        Boolean other$bold = other.getBold();
        if (this$bold == null ? other$bold != null : !((Object)this$bold).equals(other$bold)) {
            return false;
        }
        String this$fontName = this.getFontName();
        String other$fontName = other.getFontName();
        return !(this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FontProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Short $fontHeightInPoints = this.getFontHeightInPoints();
        result = result * 59 + ($fontHeightInPoints == null ? 43 : ((Object)$fontHeightInPoints).hashCode());
        Boolean $italic = this.getItalic();
        result = result * 59 + ($italic == null ? 43 : ((Object)$italic).hashCode());
        Boolean $strikeout = this.getStrikeout();
        result = result * 59 + ($strikeout == null ? 43 : ((Object)$strikeout).hashCode());
        Short $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        Short $typeOffset = this.getTypeOffset();
        result = result * 59 + ($typeOffset == null ? 43 : ((Object)$typeOffset).hashCode());
        Byte $underline = this.getUnderline();
        result = result * 59 + ($underline == null ? 43 : ((Object)$underline).hashCode());
        Integer $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        Boolean $bold = this.getBold();
        result = result * 59 + ($bold == null ? 43 : ((Object)$bold).hashCode());
        String $fontName = this.getFontName();
        result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
        return result;
    }
}

