/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.common.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import shaded.org.apache.http.Consts;
import shaded.org.apache.http.Header;
import shaded.org.apache.http.HttpHost;
import shaded.org.apache.http.HttpResponse;
import shaded.org.apache.http.HttpResponseFactory;
import shaded.org.apache.http.ParseException;
import shaded.org.apache.http.client.config.RequestConfig;
import shaded.org.apache.http.config.ConnectionConfig;
import shaded.org.apache.http.config.MessageConstraints;
import shaded.org.apache.http.config.Registry;
import shaded.org.apache.http.config.RegistryBuilder;
import shaded.org.apache.http.conn.routing.HttpRoute;
import shaded.org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import shaded.org.apache.http.conn.ssl.SSLContexts;
import shaded.org.apache.http.impl.DefaultHttpResponseFactory;
import shaded.org.apache.http.impl.client.BasicCookieStore;
import shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import shaded.org.apache.http.impl.conn.SystemDefaultDnsResolver;
import shaded.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import shaded.org.apache.http.impl.nio.client.HttpAsyncClients;
import shaded.org.apache.http.impl.nio.codecs.DefaultHttpRequestWriterFactory;
import shaded.org.apache.http.impl.nio.codecs.DefaultHttpResponseParser;
import shaded.org.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import shaded.org.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import shaded.org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import shaded.org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import shaded.org.apache.http.impl.nio.reactor.IOReactorConfig;
import shaded.org.apache.http.message.BasicHeader;
import shaded.org.apache.http.message.BasicLineParser;
import shaded.org.apache.http.message.LineParser;
import shaded.org.apache.http.nio.NHttpMessageParser;
import shaded.org.apache.http.nio.conn.NoopIOSessionStrategy;
import shaded.org.apache.http.nio.conn.SchemeIOSessionStrategy;
import shaded.org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import shaded.org.apache.http.nio.reactor.IOReactorException;
import shaded.org.apache.http.nio.reactor.SessionInputBuffer;
import shaded.org.apache.http.nio.util.HeapByteBufferAllocator;
import shaded.org.apache.http.util.CharArrayBuffer;

public class HttpClientConfig {
    public HttpClientConfig() throws IOReactorException {
        DefaultHttpResponseParserFactory responseParserFactory = new DefaultHttpResponseParserFactory(){

            @Override
            public NHttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
                BasicLineParser lineParser = new BasicLineParser(){

                    @Override
                    public Header parseHeader(CharArrayBuffer buffer) {
                        try {
                            return super.parseHeader(buffer);
                        }
                        catch (ParseException ex) {
                            return new BasicHeader(buffer.toString(), null);
                        }
                    }
                };
                return new DefaultHttpResponseParser(buffer, (LineParser)lineParser, (HttpResponseFactory)DefaultHttpResponseFactory.INSTANCE, constraints);
            }
        };
        DefaultHttpRequestWriterFactory requestWriterFactory = new DefaultHttpRequestWriterFactory();
        ManagedNHttpClientConnectionFactory connFactory = new ManagedNHttpClientConnectionFactory(requestWriterFactory, responseParserFactory, HeapByteBufferAllocator.INSTANCE);
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        BrowserCompatHostnameVerifier hostnameVerifier = new BrowserCompatHostnameVerifier();
        Registry<SchemeIOSessionStrategy> sessionStrategyRegistry = RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)new SSLIOSessionStrategy(sslcontext, hostnameVerifier))).build();
        SystemDefaultDnsResolver dnsResolver = new SystemDefaultDnsResolver(){

            @Override
            public InetAddress[] resolve(String host) throws UnknownHostException {
                if (host.equalsIgnoreCase("myhost")) {
                    return new InetAddress[]{InetAddress.getByAddress(new byte[]{127, 0, 0, 1})};
                }
                return super.resolve(host);
            }
        };
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).setConnectTimeout(30000).setSoTimeout(30000).build();
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
        PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager(ioReactor, connFactory, sessionStrategyRegistry, dnsResolver);
        MessageConstraints messageConstraints = MessageConstraints.custom().setMaxHeaderCount(200).setMaxLineLength(2000).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).setMessageConstraints(messageConstraints).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        connManager.setConnectionConfig(new HttpHost("somehost", 80), ConnectionConfig.DEFAULT);
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(10);
        connManager.setMaxPerRoute(new HttpRoute(new HttpHost("somehost", 80)), 20);
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("best-match").setExpectContinueEnabled(true).setStaleConnectionCheckEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().setConnectionManager(connManager).setDefaultCookieStore(cookieStore).setDefaultCredentialsProvider(credentialsProvider).setProxy(new HttpHost("myproxy", 8080)).setDefaultRequestConfig(defaultRequestConfig).build();
    }
}

