/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model.serialize.queue;

import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.serialize.XMLDeserializer;
import java.io.InputStream;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MessageDeserializer
extends XMLDeserializer<Message> {
    @Override
    public Message deserialize(InputStream stream) throws Exception {
        Document doc = this.getDocmentBuilder().parse(stream);
        Element root = doc.getDocumentElement();
        return this.parseMessage(root);
    }

    private Message parseMessage(Element root) throws ClientException {
        String priority;
        String dequeueCount;
        String firstDequeueTime;
        String nextVisibleTime;
        Message message = new Message();
        String messageId = this.safeGetElementContent(root, "MessageId", null);
        message.setMessageId(messageId);
        String messageBody = this.safeGetElementContent(root, "MessageBody", null);
        if (messageBody != null) {
            message.setMessageBody(messageBody, Message.MessageBodyType.RAW_STRING);
        }
        String messageBodyMD5 = this.safeGetElementContent(root, "MessageBodyMD5", null);
        message.setMessageBodyMD5(messageBodyMD5);
        String receiptHandle = this.safeGetElementContent(root, "ReceiptHandle", null);
        message.setReceiptHandle(receiptHandle);
        String enqueTime = this.safeGetElementContent(root, "EnqueueTime", null);
        if (enqueTime != null) {
            message.setEnqueueTime(new Date(Long.parseLong(enqueTime)));
        }
        if ((nextVisibleTime = this.safeGetElementContent(root, "NextVisibleTime", null)) != null) {
            message.setNextVisibleTime(new Date(Long.parseLong(nextVisibleTime)));
        }
        if ((firstDequeueTime = this.safeGetElementContent(root, "FirstDequeueTime", null)) != null) {
            message.setFirstDequeueTime(new Date(Long.parseLong(firstDequeueTime)));
        }
        if ((dequeueCount = this.safeGetElementContent(root, "DequeueCount", null)) != null) {
            message.setDequeueCount(Integer.parseInt(dequeueCount));
        }
        if ((priority = this.safeGetElementContent(root, "Priority", null)) != null) {
            message.setPriority(Integer.parseInt(priority));
        }
        return message;
    }
}

