/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.activerecord;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;

public abstract class Model<T extends Model<?>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Log log = LogFactory.getLog(this.getClass());

    public boolean insert() {
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.insert(this.sqlStatement(SqlMethod.INSERT_ONE), (Object)this));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public boolean insertOrUpdate() {
        return StringUtils.checkValNull((Object)this.pkVal()) || Objects.isNull(this.selectById(this.pkVal())) ? this.insert() : this.updateById();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteById(Serializable id) {
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.delete(this.sqlStatement(SqlMethod.DELETE_BY_ID), (Object)id));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public boolean deleteById() {
        Assert.isFalse((boolean)StringUtils.checkValNull((Object)this.pkVal()), (String)"deleteById primaryKey is null.", (Object[])new Object[0]);
        return this.deleteById(this.pkVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Wrapper<T> queryWrapper) {
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)1);
        map.put("ew", queryWrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.delete(this.sqlStatement(SqlMethod.DELETE), (Object)map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateById() {
        Assert.isFalse((boolean)StringUtils.checkValNull((Object)this.pkVal()), (String)"updateById primaryKey is null.", (Object[])new Object[0]);
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)1);
        map.put("et", this);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), (Object)map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Wrapper<T> updateWrapper) {
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)2);
        map.put("et", this);
        map.put("ew", updateWrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.update(this.sqlStatement(SqlMethod.UPDATE), (Object)map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public List<T> selectAll() {
        SqlSession sqlSession = this.sqlSession();
        try {
            List list = sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_LIST));
            return list;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T selectById(Serializable id) {
        SqlSession sqlSession = this.sqlSession();
        try {
            Model model = (Model)sqlSession.selectOne(this.sqlStatement(SqlMethod.SELECT_BY_ID), (Object)id);
            return (T)model;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public T selectById() {
        Assert.isFalse((boolean)StringUtils.checkValNull((Object)this.pkVal()), (String)"selectById primaryKey is null.", (Object[])new Object[0]);
        return this.selectById(this.pkVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> selectList(Wrapper<T> queryWrapper) {
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)1);
        map.put("ew", queryWrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            List list = sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_LIST), (Object)map);
            return list;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public T selectOne(Wrapper<T> queryWrapper) {
        return (T)((Model)SqlHelper.getObject(this.log, this.selectList(queryWrapper)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IPage<T>> E selectPage(E page, Wrapper<T> queryWrapper) {
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)2);
        map.put("ew", queryWrapper);
        map.put("page", page);
        SqlSession sqlSession = this.sqlSession();
        try {
            page.setRecords(sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_PAGE), (Object)map));
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer selectCount(Wrapper<T> queryWrapper) {
        HashMap map = CollectionUtils.newHashMapWithExpectedSize((int)1);
        map.put("ew", queryWrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            Integer n = SqlHelper.retCount((Integer)sqlSession.selectOne(this.sqlStatement(SqlMethod.SELECT_COUNT), (Object)map));
            return n;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public SqlRunner sql() {
        return new SqlRunner(this.getClass());
    }

    protected SqlSession sqlSession() {
        return SqlHelper.sqlSession(this.getClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return this.sqlStatement(sqlMethod.getMethod());
    }

    protected String sqlStatement(String sqlMethod) {
        return SqlHelper.table(this.getClass()).getSqlStatement(sqlMethod);
    }

    protected Serializable pkVal() {
        return (Serializable)ReflectionKit.getFieldValue((Object)this, (String)TableInfoHelper.getTableInfo(this.getClass()).getKeyProperty());
    }

    protected void closeSqlSession(SqlSession sqlSession) {
        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(this.getClass()));
    }
}

