/*
 * Decompiled with CFR 0.152.
 */
package com.belteshazzar.geojson;

import com.belteshazzar.geojson.GeometryGeoJSON;
import com.belteshazzar.geojson.PositionValidator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLineStringGeoJSON
extends GeometryGeoJSON {
    public List<List<List<Double>>> coordinates;

    public MultiLineStringGeoJSON() {
    }

    public MultiLineStringGeoJSON(List<List<List<Double>>> coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public boolean isValid(PositionValidator validator) {
        if (this.coordinates == null) {
            return false;
        }
        if (this.coordinates.size() == 0) {
            return false;
        }
        for (List<List<Double>> lineString : this.coordinates) {
            if (lineString == null) {
                return false;
            }
            if (lineString.size() < 2) {
                return false;
            }
            for (List<Double> position : lineString) {
                if (validator.isValid(position)) continue;
                return false;
            }
        }
        return super.isValid(validator);
    }
}

