/*
 * Decompiled with CFR 0.152.
 */
package com.belteshazzar.geojson;

import com.belteshazzar.geojson.GeometryGeoJSON;
import com.belteshazzar.geojson.PositionValidator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonGeoJSON
extends GeometryGeoJSON {
    public List<List<List<Double>>> coordinates;

    public PolygonGeoJSON() {
    }

    public PolygonGeoJSON(List<List<List<Double>>> coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public boolean isValid(PositionValidator validator) {
        if (this.coordinates == null) {
            return false;
        }
        if (this.coordinates.size() == 0) {
            return false;
        }
        for (List<List<Double>> linearRing : this.coordinates) {
            List<Double> last;
            if (linearRing == null) {
                return false;
            }
            if (linearRing.size() < 4) {
                return false;
            }
            for (List<Double> position : linearRing) {
                if (validator.isValid(position)) continue;
                return false;
            }
            List<Double> first = linearRing.get(0);
            if (validator.isEquivalent(first, last = linearRing.get(linearRing.size() - 1))) continue;
            return false;
        }
        return super.isValid(validator);
    }
}

