/*
 * Decompiled with CFR 0.152.
 */
package com.belteshazzar.geojson.validation;

import com.belteshazzar.geojson.PositionValidator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LonLatValidator
implements PositionValidator {
    @Override
    public boolean isValid(List<Double> position) {
        if (position == null) {
            return false;
        }
        if (position.size() != 2) {
            return false;
        }
        double lon = position.get(0);
        if (lon > 180.0 || lon < -180.0) {
            return false;
        }
        double lat = position.get(1);
        return !(lat > 90.0) && !(lat < -90.0);
    }

    @Override
    public boolean isValidBB(List<Double> bbox) {
        if (bbox == null) {
            return true;
        }
        if (bbox.size() != 4) {
            return false;
        }
        double minLon = bbox.get(0);
        if (minLon > 180.0 || minLon < -180.0) {
            return false;
        }
        double minLat = bbox.get(1);
        if (minLat > 90.0 || minLat < -90.0) {
            return false;
        }
        double maxLon = bbox.get(2);
        if (maxLon > 180.0 || maxLon < -180.0) {
            return false;
        }
        double maxLat = bbox.get(3);
        if (maxLat > 90.0 || maxLat < -90.0) {
            return false;
        }
        if (minLon > maxLon) {
            return false;
        }
        return !(minLat > maxLat);
    }

    @Override
    public boolean isEquivalent(List<Double> p1, List<Double> p2) {
        for (int i = 0; i < p1.size(); ++i) {
            if (p1.get(i).doubleValue() == p2.get(i).doubleValue()) continue;
            return false;
        }
        return true;
    }
}

