/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jetty9;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import java.util.concurrent.BlockingQueue;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class InstrumentedQueuedThreadPool
extends QueuedThreadPool {
    private final MetricRegistry metricRegistry;

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry) {
        this(registry, 200);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads) {
        this(registry, maxThreads, 8);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads) {
        this(registry, maxThreads, minThreads, 60000);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout) {
        this(registry, maxThreads, minThreads, idleTimeout, null);
    }

    public InstrumentedQueuedThreadPool(@Name(value="registry") MetricRegistry registry, @Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="queue") BlockingQueue<Runnable> queue) {
        super(maxThreads, minThreads, idleTimeout, queue);
        this.metricRegistry = registry;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.metricRegistry.register(MetricRegistry.name(QueuedThreadPool.class, (String[])new String[]{this.getName(), "utilization"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)(InstrumentedQueuedThreadPool.this.getThreads() - InstrumentedQueuedThreadPool.this.getIdleThreads()), (double)InstrumentedQueuedThreadPool.this.getThreads());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(QueuedThreadPool.class, (String[])new String[]{this.getName(), "size"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedQueuedThreadPool.this.getThreads();
            }
        });
        this.metricRegistry.register(MetricRegistry.name(QueuedThreadPool.class, (String[])new String[]{this.getName(), "jobs"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedQueuedThreadPool.this.getQueue().size();
            }
        });
    }
}

