/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.AbstractModulMavenGitCodeFormatMojo;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractFormatMojo
extends AbstractModulMavenGitCodeFormatMojo {
    @Parameter(property="globPattern", required=true)
    private String globPattern;

    @Override
    protected final void doExecute() throws MojoExecutionException, MojoFailureException {
        String pattern = "glob:" + this.globPattern;
        this.getLog().debug((CharSequence)("Using pattern '" + pattern + "'"));
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + this.globPattern);
        try {
            Files.walkFileTree(this.baseDir(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    if (pathMatcher.matches(path)) {
                        try {
                            AbstractFormatMojo.this.process(path);
                        }
                        catch (MojoExecutionException | MojoFailureException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof MojoExecutionException) {
                throw (MojoExecutionException)cause;
            }
            if (cause instanceof MojoFailureException) {
                throw (MojoFailureException)cause;
            }
            throw e;
        }
    }

    protected abstract void process(Path var1) throws MojoExecutionException, MojoFailureException;
}

