/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.AbstractModulMavenGitCodeFormatMojo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="on-pre-commit", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class OnPreCommitMojo
extends AbstractModulMavenGitCodeFormatMojo {
    @Parameter(property="stagedFilesFile", required=true)
    private String stagedFilesFile;

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Executing pre-commit hooks");
            this.onPreCommit();
            this.getLog().info((CharSequence)"Executed pre-commit hooks");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void onPreCommit() throws IOException {
        this.getLog().debug((CharSequence)("Staged files file is '" + this.stagedFilesFile + "'"));
        List<String> content = Files.readAllLines(Paths.get(this.stagedFilesFile, new String[0]));
        this.getLog().debug((CharSequence)("Staged files content: " + content.toString()));
        content.stream().map(StringUtils::trim).filter(StringUtils::isNotBlank).map(this::toPath).filter(this::isEligible).forEach(file -> this.codeFormatter().format((Path)file));
    }

    private Path toPath(String diffPath) {
        Path workTree = this.gitRepository().getWorkTree().toPath();
        return workTree.resolve(diffPath);
    }

    private boolean isEligible(Path file) {
        if (!file.toAbsolutePath().toString().contains(this.baseDir().toAbsolutePath().toString())) {
            this.getLog().debug((CharSequence)(file + " does not belong to the current project"));
            return false;
        }
        return true;
    }
}

