/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.io;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.util.Pool;
import java.io.IOException;
import java.io.InputStream;

public class Input
extends InputStream
implements Pool.Poolable {
    protected byte[] buffer;
    protected int position;
    protected int capacity;
    protected int limit;
    protected long total;
    protected char[] chars = new char[32];
    protected InputStream inputStream;
    protected boolean varEncoding = true;

    public Input() {
    }

    public Input(int bufferSize) {
        this.capacity = bufferSize;
        this.buffer = new byte[bufferSize];
    }

    public Input(byte[] buffer) {
        this.setBuffer(buffer, 0, buffer.length);
    }

    public Input(byte[] buffer, int offset, int count) {
        this.setBuffer(buffer, offset, count);
    }

    public Input(InputStream inputStream) {
        this(4096);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public Input(InputStream inputStream, int bufferSize) {
        this(bufferSize);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public void setBuffer(byte[] bytes) {
        this.setBuffer(bytes, 0, bytes.length);
    }

    public void setBuffer(byte[] bytes, int offset, int count) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.buffer = bytes;
        this.position = offset;
        this.limit = offset + count;
        this.capacity = bytes.length;
        this.total = 0L;
        this.inputStream = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.limit = 0;
        this.reset();
    }

    public boolean getVariableLengthEncoding() {
        return this.varEncoding;
    }

    public void setVariableLengthEncoding(boolean varEncoding) {
        this.varEncoding = varEncoding;
    }

    public long total() {
        return this.total + (long)this.position;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int limit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void reset() {
        this.position = 0;
        this.total = 0L;
    }

    public void skip(int count) throws KryoException {
        int skipCount = Math.min(this.limit - this.position, count);
        while (true) {
            this.position += skipCount;
            if ((count -= skipCount) == 0) break;
            skipCount = Math.min(count, this.capacity);
            this.require(skipCount);
        }
    }

    protected int fill(byte[] buffer, int offset, int count) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            return this.inputStream.read(buffer, offset, count);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }

    protected int require(int required) throws KryoException {
        int count;
        int remaining = this.limit - this.position;
        if (remaining >= required) {
            return remaining;
        }
        if (required > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + required);
        }
        if (remaining > 0) {
            count = this.fill(this.buffer, this.limit, this.capacity - this.limit);
            if (count == -1) {
                throw new KryoException("Buffer underflow.");
            }
            if ((remaining += count) >= required) {
                this.limit += count;
                return remaining;
            }
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, remaining);
        this.total += (long)this.position;
        this.position = 0;
        do {
            if ((count = this.fill(this.buffer, remaining, this.capacity - remaining)) != -1) continue;
            if (remaining >= required) break;
            throw new KryoException("Buffer underflow.");
        } while ((remaining += count) < required);
        this.limit = remaining;
        return remaining;
    }

    protected int optional(int optional) throws KryoException {
        int remaining = this.limit - this.position;
        if (remaining >= optional) {
            return optional;
        }
        optional = Math.min(optional, this.capacity);
        int count = this.fill(this.buffer, this.limit, this.capacity - this.limit);
        if (count == -1) {
            return remaining == 0 ? -1 : Math.min(remaining, optional);
        }
        if ((remaining += count) >= optional) {
            this.limit += count;
            return optional;
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, remaining);
        this.total += (long)this.position;
        this.position = 0;
        while ((count = this.fill(this.buffer, remaining, this.capacity - remaining)) != -1 && (remaining += count) < optional) {
        }
        this.limit = remaining;
        return remaining == 0 ? -1 : Math.min(remaining, optional);
    }

    public boolean end() {
        return this.optional(1) <= 0;
    }

    @Override
    public int available() throws IOException {
        return this.limit - this.position + (this.inputStream != null ? this.inputStream.available() : 0);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] bytes) throws KryoException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int startingCount = count;
        int copyCount = Math.min(this.limit - this.position, count);
        do {
            System.arraycopy(this.buffer, this.position, bytes, offset, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = this.optional(count);
            if (copyCount != -1) continue;
            if (startingCount == count) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return startingCount - count;
    }

    @Override
    public long skip(long count) throws KryoException {
        int skip;
        for (long remaining = count; remaining > 0L; remaining -= (long)skip) {
            skip = (int)Math.min(0x7FFFFFF7L, remaining);
            this.skip(skip);
        }
        return count;
    }

    @Override
    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte readByte() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return this.buffer[this.position++];
    }

    public int readByteUnsigned() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return this.buffer[this.position++] & 0xFF;
    }

    public byte[] readBytes(int length) throws KryoException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return bytes;
    }

    public void readBytes(byte[] bytes) throws KryoException {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.limit - this.position, count);
        while (true) {
            System.arraycopy(this.buffer, this.position, bytes, offset, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = Math.min(count, this.capacity);
            this.require(copyCount);
        }
    }

    public int readInt() throws KryoException {
        this.require(4);
        byte[] buffer = this.buffer;
        int p = this.position;
        this.position = p + 4;
        return buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16 | (buffer[p + 3] & 0xFF) << 24;
    }

    public int readInt(boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            return this.readVarInt(optimizePositive);
        }
        return this.readInt();
    }

    public boolean canReadInt() throws KryoException {
        if (this.varEncoding) {
            return this.canReadVarInt();
        }
        if (this.limit - this.position >= 4) {
            return true;
        }
        return this.optional(4) == 4;
    }

    public int readVarInt(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 5) {
            return this.readVarInt_slow(optimizePositive);
        }
        byte b = this.buffer[this.position++];
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            byte[] buffer = this.buffer;
            int p = this.position;
            b = buffer[p++];
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer[p++];
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer[p++];
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer[p++];
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
            this.position = p;
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    private int readVarInt_slow(boolean optimizePositive) {
        byte b = this.buffer[this.position++];
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            byte[] buffer = this.buffer;
            b = buffer[this.position++];
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                b = buffer[this.position++];
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    b = buffer[this.position++];
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        b = buffer[this.position++];
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public boolean canReadVarInt() throws KryoException {
        if (this.limit - this.position >= 5) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        int limit = this.limit;
        byte[] buffer = this.buffer;
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        return p != limit;
    }

    public boolean readVarIntFlag() {
        if (this.position == this.limit) {
            this.require(1);
        }
        return (this.buffer[this.position] & 0x80) != 0;
    }

    public int readVarIntFlag(boolean optimizePositive) {
        if (this.require(1) < 5) {
            return this.readVarIntFlag_slow(optimizePositive);
        }
        byte b = this.buffer[this.position++];
        int result = b & 0x3F;
        if ((b & 0x40) != 0) {
            byte[] buffer = this.buffer;
            int p = this.position;
            b = buffer[p++];
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                b = buffer[p++];
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    b = buffer[p++];
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        b = buffer[p++];
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
            this.position = p;
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    private int readVarIntFlag_slow(boolean optimizePositive) {
        byte b = this.buffer[this.position++];
        int result = b & 0x3F;
        if ((b & 0x40) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            byte[] buffer = this.buffer;
            b = buffer[this.position++];
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                b = buffer[this.position++];
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    b = buffer[this.position++];
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        b = buffer[this.position++];
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public long readLong() throws KryoException {
        this.require(8);
        byte[] buffer = this.buffer;
        int p = this.position;
        this.position = p + 8;
        return (long)(buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16) | (long)(buffer[p + 3] & 0xFF) << 24 | (long)(buffer[p + 4] & 0xFF) << 32 | (long)(buffer[p + 5] & 0xFF) << 40 | (long)(buffer[p + 6] & 0xFF) << 48 | (long)buffer[p + 7] << 56;
    }

    public long readLong(boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            return this.readVarLong(optimizePositive);
        }
        return this.readLong();
    }

    public long readVarLong(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 9) {
            return this.readVarLong_slow(optimizePositive);
        }
        int p = this.position;
        byte b = this.buffer[p++];
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            byte[] buffer = this.buffer;
            b = buffer[p++];
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = buffer[p++];
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = buffer[p++];
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = buffer[p++];
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = buffer[p++];
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = buffer[p++];
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = buffer[p++];
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = buffer[p++];
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.position = p;
        return optimizePositive ? result : result >>> 1 ^ -(result & 1L);
    }

    private long readVarLong_slow(boolean optimizePositive) {
        byte b = this.buffer[this.position++];
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            byte[] buffer = this.buffer;
            b = buffer[this.position++];
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                b = buffer[this.position++];
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    b = buffer[this.position++];
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        b = buffer[this.position++];
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            if (this.position == this.limit) {
                                this.require(1);
                            }
                            b = buffer[this.position++];
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                if (this.position == this.limit) {
                                    this.require(1);
                                }
                                b = buffer[this.position++];
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    if (this.position == this.limit) {
                                        this.require(1);
                                    }
                                    b = buffer[this.position++];
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        if (this.position == this.limit) {
                                            this.require(1);
                                        }
                                        b = buffer[this.position++];
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1L);
    }

    public boolean canReadLong() throws KryoException {
        if (this.varEncoding) {
            return this.canReadVarLong();
        }
        if (this.limit - this.position >= 8) {
            return true;
        }
        return this.optional(8) == 8;
    }

    public boolean canReadVarLong() throws KryoException {
        if (this.limit - this.position >= 9) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        int limit = this.limit;
        byte[] buffer = this.buffer;
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        return p != limit;
    }

    public float readFloat() throws KryoException {
        this.require(4);
        byte[] buffer = this.buffer;
        int p = this.position;
        this.position = p + 4;
        return Float.intBitsToFloat(buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16 | (buffer[p + 3] & 0xFF) << 24);
    }

    public float readVarFloat(float precision, boolean optimizePositive) throws KryoException {
        return (float)this.readVarInt(optimizePositive) / precision;
    }

    public double readDouble() throws KryoException {
        this.require(8);
        byte[] buffer = this.buffer;
        int p = this.position;
        this.position = p + 8;
        return Double.longBitsToDouble((long)(buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16) | (long)(buffer[p + 3] & 0xFF) << 24 | (long)(buffer[p + 4] & 0xFF) << 32 | (long)(buffer[p + 5] & 0xFF) << 40 | (long)(buffer[p + 6] & 0xFF) << 48 | (long)buffer[p + 7] << 56);
    }

    public double readVarDouble(double precision, boolean optimizePositive) throws KryoException {
        return (double)this.readVarLong(optimizePositive) / precision;
    }

    public short readShort() throws KryoException {
        this.require(2);
        int p = this.position;
        this.position = p + 2;
        return (short)(this.buffer[p] & 0xFF | (this.buffer[p + 1] & 0xFF) << 8);
    }

    public int readShortUnsigned() throws KryoException {
        this.require(2);
        int p = this.position;
        this.position = p + 2;
        return this.buffer[p] & 0xFF | (this.buffer[p + 1] & 0xFF) << 8;
    }

    public char readChar() throws KryoException {
        this.require(2);
        int p = this.position;
        this.position = p + 2;
        return (char)(this.buffer[p] & 0xFF | (this.buffer[p + 1] & 0xFF) << 8);
    }

    public boolean readBoolean() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return this.buffer[this.position++] == 1;
    }

    public String readString() {
        if (!this.readVarIntFlag()) {
            return this.readAsciiString();
        }
        int charCount = this.readVarIntFlag(true);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        this.readUtf8Chars(--charCount);
        return new String(this.chars, 0, charCount);
    }

    public StringBuilder readStringBuilder() {
        if (!this.readVarIntFlag()) {
            return new StringBuilder(this.readAsciiString());
        }
        int charCount = this.readVarIntFlag(true);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder(0);
            }
        }
        this.readUtf8Chars(--charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.chars, 0, charCount);
        return builder;
    }

    private void readUtf8Chars(int charCount) {
        if (this.chars.length < charCount) {
            this.chars = new char[charCount];
        }
        byte[] buffer = this.buffer;
        char[] chars = this.chars;
        int charIndex = 0;
        int count = Math.min(this.require(1), charCount);
        int p = this.position;
        while (charIndex < count) {
            byte b;
            if ((b = buffer[p++]) < 0) {
                --p;
                break;
            }
            chars[charIndex++] = (char)b;
        }
        this.position = p;
        if (charIndex < charCount) {
            this.readUtf8Chars_slow(charCount, charIndex);
        }
    }

    private void readUtf8Chars_slow(int charCount, int charIndex) {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        while (charIndex < charCount) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int b = buffer[this.position++] & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex] = (char)b;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    chars[charIndex] = (char)((b & 0x1F) << 6 | buffer[this.position++] & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    int p = this.position;
                    this.position = p + 2;
                    chars[charIndex] = (char)((b & 0xF) << 12 | (buffer[p] & 0x3F) << 6 | buffer[p + 1] & 0x3F);
                }
            }
            ++charIndex;
        }
    }

    private String readAsciiString() {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        int p = this.position;
        int charCount = 0;
        int n = Math.min(chars.length, this.limit - this.position);
        while (charCount < n) {
            byte b = buffer[p];
            if ((b & 0x80) == 128) {
                this.position = p + 1;
                chars[charCount] = (char)(b & 0x7F);
                return new String(chars, 0, charCount + 1);
            }
            chars[charCount] = (char)b;
            ++charCount;
            ++p;
        }
        this.position = p;
        return this.readAscii_slow(charCount);
    }

    private String readAscii_slow(int charCount) {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        while (true) {
            if (this.position == this.limit) {
                this.require(1);
            }
            byte b = buffer[this.position++];
            if (charCount == chars.length) {
                char[] newChars = new char[charCount * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount);
                chars = newChars;
                this.chars = newChars;
            }
            if ((b & 0x80) == 128) {
                chars[charCount] = (char)(b & 0x7F);
                return new String(chars, 0, charCount + 1);
            }
            chars[charCount++] = (char)b;
        }
    }

    public int[] readInts(int length) throws KryoException {
        int[] array = new int[length];
        if (this.optional(length << 2) == length << 2) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int i = 0;
            while (i < length) {
                array[i] = buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16 | (buffer[p + 3] & 0xFF) << 24;
                ++i;
                p += 4;
            }
            this.position = p;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readInt();
            }
        }
        return array;
    }

    public int[] readInts(int length, boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            int[] array = new int[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.readVarInt(optimizePositive);
            }
            return array;
        }
        return this.readInts(length);
    }

    public long[] readLongs(int length) throws KryoException {
        long[] array = new long[length];
        if (this.optional(length << 3) == length << 3) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int i = 0;
            while (i < length) {
                array[i] = (long)(buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16) | (long)(buffer[p + 3] & 0xFF) << 24 | (long)(buffer[p + 4] & 0xFF) << 32 | (long)(buffer[p + 5] & 0xFF) << 40 | (long)(buffer[p + 6] & 0xFF) << 48 | (long)buffer[p + 7] << 56;
                ++i;
                p += 8;
            }
            this.position = p;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readLong();
            }
        }
        return array;
    }

    public long[] readLongs(int length, boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            long[] array = new long[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.readVarLong(optimizePositive);
            }
            return array;
        }
        return this.readLongs(length);
    }

    public float[] readFloats(int length) throws KryoException {
        float[] array = new float[length];
        if (this.optional(length << 2) == length << 2) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int i = 0;
            while (i < length) {
                array[i] = Float.intBitsToFloat(buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16 | (buffer[p + 3] & 0xFF) << 24);
                ++i;
                p += 4;
            }
            this.position = p;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readFloat();
            }
        }
        return array;
    }

    public double[] readDoubles(int length) throws KryoException {
        double[] array = new double[length];
        if (this.optional(length << 3) == length << 3) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int i = 0;
            while (i < length) {
                array[i] = Double.longBitsToDouble((long)(buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16) | (long)(buffer[p + 3] & 0xFF) << 24 | (long)(buffer[p + 4] & 0xFF) << 32 | (long)(buffer[p + 5] & 0xFF) << 40 | (long)(buffer[p + 6] & 0xFF) << 48 | (long)buffer[p + 7] << 56);
                ++i;
                p += 8;
            }
            this.position = p;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readDouble();
            }
        }
        return array;
    }

    public short[] readShorts(int length) throws KryoException {
        short[] array = new short[length];
        if (this.optional(length << 1) == length << 1) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int i = 0;
            while (i < length) {
                array[i] = (short)(buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8);
                ++i;
                p += 2;
            }
            this.position = p;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readShort();
            }
        }
        return array;
    }

    public char[] readChars(int length) throws KryoException {
        char[] array = new char[length];
        if (this.optional(length << 1) == length << 1) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int i = 0;
            while (i < length) {
                array[i] = (char)(buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8);
                ++i;
                p += 2;
            }
            this.position = p;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readChar();
            }
        }
        return array;
    }

    public boolean[] readBooleans(int length) throws KryoException {
        boolean[] array = new boolean[length];
        if (this.optional(length) == length) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int i = 0;
            while (i < length) {
                array[i] = buffer[p] != 0;
                ++i;
                ++p;
            }
            this.position = p;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readBoolean();
            }
        }
        return array;
    }
}

