/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class XmlAdapterJsonDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    protected final XmlAdapter<Object, Object> _xmlAdapter;
    protected final JavaType _valueType;
    protected final JsonDeserializer<?> _deserializer;

    public XmlAdapterJsonDeserializer(XmlAdapter<?, ?> xmlAdapter) {
        this(xmlAdapter, null, null);
    }

    protected XmlAdapterJsonDeserializer(XmlAdapter<Object, Object> adapter, JavaType valueType, JsonDeserializer<?> deserializer) {
        super(Object.class);
        if (adapter == null) {
            throw new IllegalArgumentException("Null XmlAdapter passed");
        }
        this._xmlAdapter = adapter;
        this._valueType = valueType;
        this._deserializer = deserializer;
    }

    public JsonDeserializer<Object> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType type;
        TypeFactory typeFactory = ctxt.getTypeFactory();
        JavaType[] rawTypes = typeFactory.findTypeParameters(type = typeFactory.constructType(this._xmlAdapter.getClass()), XmlAdapter.class);
        JavaType valueType = rawTypes == null || rawTypes.length == 0 ? TypeFactory.unknownType() : rawTypes[0];
        JsonDeserializer deser = ctxt.findContextualValueDeserializer(valueType, property);
        return new XmlAdapterJsonDeserializer(this._xmlAdapter, valueType, deser);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonDeserializer<?> deser = this._deserializer;
        if (deser == null) {
            throw new IllegalStateException("No deserializer assigned for XmlAdapterJsonDeserializer (" + this._xmlAdapter.getClass().getName() + "): resolve() not called?");
        }
        Object boundObject = deser.deserialize(jp, ctxt);
        try {
            return this._xmlAdapter.unmarshal(boundObject);
        }
        catch (Exception e) {
            throw new JsonMappingException("Unable to unmarshal (to type " + this._valueType + "): " + e.getMessage(), (Throwable)e);
        }
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }
}

