/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

public enum SfdcApiType {
    Enterprise(true, "urn:enterprise.soap.sforce.com", "urn:sobject.enterprise.soap.sforce.com", "verifyEnterpriseEndpoint"),
    Partner(true, "urn:partner.soap.sforce.com", "urn:sobject.partner.soap.sforce.com", "verifyPartnerEndpoint"),
    Metadata(false, "http://soap.sforce.com/2006/04/metadata"),
    CrossInstance(false, "http://soap.sforce.com/2006/05/crossinstance", "http://soap.sforce.com/2006/05/crossinstance", null),
    Internal(false, "http://soap.sforce.com/2007/07/internal", "http://soap.sforce.com/2007/07/internal", null),
    ClientSync(false, "http://soap.sforce.com/2009/10/clientsync", "http://soap.sforce.com/2009/10/clientsync", null),
    SyncApi(false, "http://soap.sforce.com/schemas/class/syncapi/Command", "http://soap.sforce.com/schemas/class/syncapi/Command", null),
    Tooling(true, "urn:tooling.soap.sforce.com", "urn:tooling.soap.sforce.com", "verifyToolingEndpoint");

    boolean hasLoginCall;
    String namespace;
    String sobjectNamespace;
    String verifyEndpoint;

    private SfdcApiType(boolean hasLoginCall, String namespace) {
        this(hasLoginCall, namespace, null, null);
    }

    private SfdcApiType(boolean hasLoginCall, String namespace, String sobjectNamespace, String verifyEndpoint) {
        this.hasLoginCall = hasLoginCall;
        this.namespace = namespace;
        this.sobjectNamespace = sobjectNamespace;
        this.verifyEndpoint = verifyEndpoint;
    }

    public boolean hasLoginCall() {
        return this.hasLoginCall;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSobjectNamespace() {
        return this.sobjectNamespace;
    }

    public String getVerifyEndpoint() {
        return this.verifyEndpoint;
    }

    public static SfdcApiType getFromNamespace(String namespace) {
        for (SfdcApiType type : SfdcApiType.values()) {
            if (!type.getNamespace().equals(namespace)) continue;
            return type;
        }
        return null;
    }

    public static SfdcApiType getFromSobjectNamespace(String namespace) {
        for (SfdcApiType type : SfdcApiType.values()) {
            if (type.getSobjectNamespace() == null || !type.getSobjectNamespace().equals(namespace)) continue;
            return type;
        }
        return null;
    }
}

