/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.generator.visitors;

import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Group;
import com.github.curiousoddman.rgxgen.generator.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.generator.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.generator.visitors.NodeVisitor;
import com.github.curiousoddman.rgxgen.iterators.ReferenceIterator;
import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import com.github.curiousoddman.rgxgen.iterators.suppliers.ArrayIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.ChoiceIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.GroupIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.IncrementalLengthIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.NegativeIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.PermutationsIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.ReferenceIteratorSupplier;
import com.github.curiousoddman.rgxgen.iterators.suppliers.SingleValueIteratorSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueGenerationVisitor
implements NodeVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueGenerationVisitor.class);
    private final List<Supplier<StringIterator>> aIterators = new ArrayList<Supplier<StringIterator>>();
    private final Map<Integer, List<ReferenceIterator>> aReferenceIteratorMap;
    private final Map<Integer, StringIterator> aGroupIterators;

    public UniqueGenerationVisitor() {
        this(new HashMap<Integer, List<ReferenceIterator>>(), new HashMap<Integer, StringIterator>());
    }

    public UniqueGenerationVisitor(Map<Integer, List<ReferenceIterator>> referenceIteratorMap, Map<Integer, StringIterator> groupIterators) {
        LOGGER.trace("Creating\n\trefs: {}\n\tgrps: {}", referenceIteratorMap, groupIterators);
        this.aReferenceIteratorMap = referenceIteratorMap;
        this.aGroupIterators = groupIterators;
    }

    @Override
    public void visit(SymbolSet node) {
        this.aIterators.add(new ArrayIteratorSupplier(node.getSymbols()));
    }

    @Override
    public void visit(Choice node) {
        ArrayList<List<Supplier<StringIterator>>> nodeIterators = new ArrayList<List<Supplier<StringIterator>>>(node.getNodes().length);
        for (Node n : node.getNodes()) {
            UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators);
            n.visit(v);
            nodeIterators.add(v.aIterators);
        }
        this.aIterators.add(new ChoiceIteratorSupplier(nodeIterators));
    }

    @Override
    public void visit(FinalSymbol node) {
        this.aIterators.add(new SingleValueIteratorSupplier(node.getValue()));
    }

    @Override
    public void visit(Repeat node) {
        UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators);
        node.getNode().visit(v);
        this.aIterators.add(new IncrementalLengthIteratorSupplier(new PermutationsIteratorSupplier(v.aIterators), node.getMin(), node.getMax()));
    }

    @Override
    public void visit(Sequence node) {
        for (Node n : node.getNodes()) {
            n.visit(this);
        }
    }

    @Override
    public void visit(NotSymbol notSymbol) {
        this.aIterators.add(new NegativeIteratorSupplier(notSymbol.getSubPattern(), new IncrementalLengthIteratorSupplier(new ArrayIteratorSupplier(SymbolSet.getAllSymbols()), 0, -1)));
    }

    @Override
    public void visit(GroupRef groupRef) {
        this.aIterators.add(new ReferenceIteratorSupplier(this.aReferenceIteratorMap, this.aGroupIterators, groupRef.getIndex()));
    }

    @Override
    public void visit(Group group) {
        UniqueGenerationVisitor v = new UniqueGenerationVisitor(this.aReferenceIteratorMap, this.aGroupIterators);
        group.getNode().visit(v);
        this.aIterators.add(new GroupIteratorSupplier(new PermutationsIteratorSupplier(v.aIterators), this.aReferenceIteratorMap, this.aGroupIterators, group.getIndex()));
    }

    public StringIterator getUniqueStrings() {
        return new PermutationsIteratorSupplier(this.aIterators).get();
    }
}

