/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import com.github.curiousoddman.rgxgen.visitors.helpers.SymbolSetIndexer;
import java.util.NoSuchElementException;

public class IndexIterator
implements StringIterator {
    private final int maxIndex;
    private final SymbolSetIndexer symbolSetIndexer;
    private int index = -1;

    public IndexIterator(SymbolSetIndexer symbolSetIndexer) {
        this.symbolSetIndexer = symbolSetIndexer;
        this.maxIndex = symbolSetIndexer.size() - 1;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    @Override
    public String next() {
        ++this.index;
        if (this.index >= this.symbolSetIndexer.size()) {
            throw new NoSuchElementException("Not enough elements in arrays");
        }
        return String.valueOf(this.symbolSetIndexer.get(this.index));
    }

    @Override
    public void reset() {
        this.index = -1;
    }

    @Override
    public String current() {
        return String.valueOf(this.symbolSetIndexer.get(this.index));
    }
}

