/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.support.expirekey;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.support.ExpireKey;

public class DefaultExpireKey
implements ExpireKey {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExpireKey.class);
    private Map<String, Integer> map = new ConcurrentHashMap<String, Integer>();
    private Integer period = 60;
    private ScheduledExecutorService scheduledExecutorService;

    public DefaultExpireKey() {
        this.cleanExpireKey();
    }

    public DefaultExpireKey(int period) {
        this.period = period;
        this.cleanExpireKey();
    }

    private void cleanExpireKey() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                Thread thread = Executors.defaultThreadFactory().newThread(arg0);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                logger.debug("in clean");
                ArrayList<String> removeKey = new ArrayList<String>();
                for (String key : DefaultExpireKey.this.map.keySet()) {
                    Integer value = (Integer)DefaultExpireKey.this.map.get(key);
                    if (value == null || (long)value.intValue() > System.currentTimeMillis() / 1000L) continue;
                    removeKey.add(key);
                }
                for (String key : removeKey) {
                    DefaultExpireKey.this.map.remove(key);
                }
                logger.debug("clean {} keys", (Object)removeKey.size());
            }
        }, 10L, this.period.intValue(), TimeUnit.SECONDS);
    }

    @Override
    public boolean add(String key, int expire) {
        this.map.put(key, (int)(System.currentTimeMillis() / 1000L) + expire);
        return false;
    }

    @Override
    public boolean add(String key) {
        return this.add(key, DEFAULT_EXPIRE);
    }

    @Override
    public boolean exists(String key) {
        Integer value = this.map.get(key);
        if (value == null) {
            return false;
        }
        return (long)value.intValue() > System.currentTimeMillis() / 1000L;
    }
}

