/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.InterceptedInvocationHandler;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestInvocationHandler;

public final class RestProxyFactory {
    private RestProxyFactory() {
    }

    public static <I> I createProxy(Class<I> restInterface, String baseUrl, ClientConfig config, Interceptor ... interceptors) {
        return RestProxyFactory.createProxy(restInterface, RestProxyFactory.wrap(new RestInvocationHandler(restInterface, baseUrl, config), interceptors), new Interceptor[0]);
    }

    static InvocationHandler wrap(InvocationHandler handler, Interceptor ... interceptors) {
        for (Interceptor interceptor : interceptors) {
            handler = new InterceptedInvocationHandler(interceptor, handler);
        }
        return handler;
    }

    public static <I> I createProxy(Class<I> restInterface, String baseUrl) {
        return RestProxyFactory.createProxy(restInterface, baseUrl, null, new Interceptor[0]);
    }

    static <I> I createProxy(Class<I> restInterface, InvocationHandler restInvocationHandler, Interceptor ... interceptors) {
        Object proxy = Proxy.newProxyInstance(restInterface.getClassLoader(), new Class[]{restInterface}, RestProxyFactory.wrap(restInvocationHandler, interceptors));
        return (I)proxy;
    }
}

