/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu.serialization.jackson.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;

public abstract class EnumIntDeserializer<E extends Enum<E>>
extends JsonDeserializer<E> {
    private final Class<E> enumClass;

    protected EnumIntDeserializer(Class<E> enumClass) {
        this.enumClass = enumClass;
    }

    public E deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Enum[] constants = (Enum[])this.enumClass.getEnumConstants();
        return (E)constants[jp.getValueAsInt() - this.getIndexBase()];
    }

    protected int getIndexBase() {
        return 0;
    }
}

