/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.collection.ImmutableCollection;

/**
 * This file was automatically generated from template file immutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface ImmutableBooleanCollection extends BooleanIterable
{
    <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function);

    ImmutableBooleanCollection select(BooleanPredicate predicate);

    ImmutableBooleanCollection reject(BooleanPredicate predicate);

    ImmutableBooleanCollection newWith(boolean element);

    ImmutableBooleanCollection newWithout(boolean element);

    ImmutableBooleanCollection newWithAll(BooleanIterable elements);

    ImmutableBooleanCollection newWithoutAll(BooleanIterable elements);
}
