/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.bag.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.bag.primitive.ImmutableIntBag;

/**
 * A factory which creates instances of type {@link ImmutableIntBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableIntBagFactory
{
    /**
     * @since 6.0
     */
    ImmutableIntBag empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableIntBag of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableIntBag with();

    /**
     * Same as {@link #with(int)}.
     */
    ImmutableIntBag of(int one);

    ImmutableIntBag with(int one);

    /**
     * Same as {@link #with(int[])}.
     */
    ImmutableIntBag of(int... items);

    ImmutableIntBag with(int... items);

    /**
     * Same as {@link #withAll(IntIterable)}.
     */
    ImmutableIntBag ofAll(IntIterable items);

    ImmutableIntBag withAll(IntIterable items);
}
