/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharToIntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.predicate.primitive.CharIntPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableCharIntMap extends CharIntMap, MutableIntValuesMap
{
    void put(char key, int value);

    void putAll(CharIntMap map);

    void removeKey(char key);

    void remove(char key);

    int removeKeyIfAbsent(char key, int value);

    int getIfAbsentPut(char key, int value);

    int getIfAbsentPut(char key, IntFunction0 function);

    int getIfAbsentPutWithKey(char key, CharToIntFunction function);

    <P> int getIfAbsentPutWith(char key, IntFunction<? super P> function, P parameter);

    int updateValue(char key, int initialValueIfAbsent, IntToIntFunction function);

    MutableCharIntMap select(CharIntPredicate predicate);

    MutableCharIntMap reject(CharIntPredicate predicate);

    MutableCharIntMap withKeyValue(char key, int value);

    MutableCharIntMap withoutKey(char key);

    MutableCharIntMap withoutAllKeys(CharIterable keys);

    MutableCharIntMap asUnmodifiable();

    MutableCharIntMap asSynchronized();


    int addToValue(char key, int toBeAdded);
}
