/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import java.util.Collection;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.iterator.MutableBooleanIterator;
import com.gs.collections.api.collection.MutableCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface MutableBooleanCollection extends BooleanIterable
{
    MutableBooleanIterator booleanIterator();

    boolean add(boolean element);

    boolean addAll(boolean... source);

    boolean addAll(BooleanIterable source);

    boolean remove(boolean value);

    boolean removeAll(BooleanIterable source);

    boolean removeAll(boolean... source);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(BooleanIterable elements);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(boolean... source);

    void clear();

    MutableBooleanCollection select(BooleanPredicate predicate);

    MutableBooleanCollection reject(BooleanPredicate predicate);

    <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableBooleanCollection with(boolean element);

    MutableBooleanCollection without(boolean element);

    MutableBooleanCollection withAll(BooleanIterable elements);

    MutableBooleanCollection withoutAll(BooleanIterable elements);

    MutableBooleanCollection asUnmodifiable();

    MutableBooleanCollection asSynchronized();

    ImmutableBooleanCollection toImmutable();
}
