/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import java.util.Collection;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.iterator.MutableByteIterator;
import com.gs.collections.api.collection.MutableCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface MutableByteCollection extends ByteIterable
{
    MutableByteIterator byteIterator();

    boolean add(byte element);

    boolean addAll(byte... source);

    boolean addAll(ByteIterable source);

    boolean remove(byte value);

    boolean removeAll(ByteIterable source);

    boolean removeAll(byte... source);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(ByteIterable elements);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(byte... source);

    void clear();

    MutableByteCollection select(BytePredicate predicate);

    MutableByteCollection reject(BytePredicate predicate);

    <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function);

    MutableByteCollection with(byte element);

    MutableByteCollection without(byte element);

    MutableByteCollection withAll(ByteIterable elements);

    MutableByteCollection withoutAll(ByteIterable elements);

    MutableByteCollection asUnmodifiable();

    MutableByteCollection asSynchronized();

    ImmutableByteCollection toImmutable();
}
