/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.bag.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;

/**
 * A factory which creates instances of type {@link MutableIntBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableIntBagFactory
{
    MutableIntBag empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntBag of();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntBag with();

    /**
     * Same as {@link #with(int[])}.
     */
    MutableIntBag of(int... items);

    MutableIntBag with(int... items);

    /**
     * Same as {@link #withAll(IntIterable)}.
     */
    MutableIntBag ofAll(IntIterable items);

    MutableIntBag withAll(IntIterable items);
}
