/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.list.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.list.primitive.MutableShortList;

/**
 * A factory which creates instances of type {@link MutableShortList}.
 * This file was automatically generated from template file mutablePrimitiveListFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableShortListFactory
{
    MutableShortList empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableShortList of();

    /**
     * Same as {@link #empty()}.
     */
    MutableShortList with();

    /**
     * Same as {@link #with(short[])}.
     */
    MutableShortList of(short... items);

    MutableShortList with(short... items);

    /**
     * Same as {@link #withAll(ShortIterable)}.
     */
    MutableShortList ofAll(ShortIterable items);

    MutableShortList withAll(ShortIterable items);
}
