/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.LongCharMap;
import com.gs.collections.api.map.primitive.ImmutableLongCharMap;

/**
 * A factory which creates instances of type {@link ImmutableLongCharMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableLongCharMapFactory
{
    /**
     * @since 6.0
     */
    ImmutableLongCharMap empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableLongCharMap of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableLongCharMap with();

    /**
     * Same as {@link #with(long, char)}.
     */
    ImmutableLongCharMap of(long key, char value);

    ImmutableLongCharMap with(long key, char value);

    /**
     * Same as {@link #withAll(LongCharMap)}.
     */
    ImmutableLongCharMap ofAll(LongCharMap map);

    ImmutableLongCharMap withAll(LongCharMap map);
}
