/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.MutableLongFloatMap;
import com.gs.collections.api.map.primitive.LongFloatMap;

/**
 * A factory which creates instances of type {@link MutableLongFloatMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableLongFloatMapFactory
{
    MutableLongFloatMap empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableLongFloatMap of();

    /**
     * Same as {@link #empty()}.
     */
    MutableLongFloatMap with();

    /**
     * Same as {@link #withAll(LongFloatMap)}.
     */
    MutableLongFloatMap ofAll(LongFloatMap map);

    MutableLongFloatMap withAll(LongFloatMap map);
}
