/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.stack.primitive.ImmutableFloatStack;

/**
 * A factory which creates instances of type {@link ImmutableFloatStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableFloatStackFactory
{
    /**
     * @since 6.0
     */
    ImmutableFloatStack empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableFloatStack of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableFloatStack with();

    /**
     * Same as {@link #with(float)}.
     */
    ImmutableFloatStack of(float one);

    ImmutableFloatStack with(float one);

    /**
     * Same as {@link #with(float[])}.
     */
    ImmutableFloatStack of(float... items);

    ImmutableFloatStack with(float... items);

    /**
     * Same as {@link #withAll(FloatIterable)}.
     */
    ImmutableFloatStack ofAll(FloatIterable items);

    ImmutableFloatStack withAll(FloatIterable items);

    /**
     * Same as {@link #withAllReversed(FloatIterable)}.
     */
    ImmutableFloatStack ofAllReversed(FloatIterable items);

    ImmutableFloatStack withAllReversed(FloatIterable items);
}
