/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.stack.primitive.MutableDoubleStack;

/**
 * A factory which creates instances of type {@link MutableDoubleStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableDoubleStackFactory
{
    MutableDoubleStack empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableDoubleStack of();

    /**
     * Same as {@link #empty()}.
     */
    MutableDoubleStack with();

    /**
     * Same as {@link #with(double[])}.
     */
    MutableDoubleStack of(double... items);

    MutableDoubleStack with(double... items);

    /**
     * Same as {@link #withAll(DoubleIterable)}.
     */
    MutableDoubleStack ofAll(DoubleIterable items);

    MutableDoubleStack withAll(DoubleIterable items);

    /**
     * Same as {@link #withAllReversed(DoubleIterable)}.
     */
    MutableDoubleStack ofAllReversed(DoubleIterable items);

    MutableDoubleStack withAllReversed(DoubleIterable items);
}
