/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableShortList extends MutableShortCollection, ShortList
{
    void addAtIndex(int index, short element);

    boolean addAllAtIndex(int index, short... source);

    boolean addAllAtIndex(int index, ShortIterable source);

    short removeAtIndex(int index);

    short set(int index, short element);

    MutableShortList select(ShortPredicate predicate);

    MutableShortList reject(ShortPredicate predicate);

    MutableShortList with(short element);

    MutableShortList without(short element);

    MutableShortList withAll(ShortIterable elements);

    MutableShortList withoutAll(ShortIterable elements);

    <V> MutableList<V> collect(ShortToObjectFunction<? extends V> function);

    MutableShortList reverseThis();

    MutableShortList toReversed();

    /**
     * @since 6.0.
     */
    MutableShortList distinct();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableShortList sortThis();

    MutableShortList asUnmodifiable();

    MutableShortList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableShortList toImmutable();

    MutableShortList subList(int fromIndex, int toIndex);
}
