/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToLongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.predicate.primitive.IntLongPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableIntLongMap extends IntLongMap, MutableLongValuesMap
{
    void put(int key, long value);

    void putAll(IntLongMap map);

    void removeKey(int key);

    void remove(int key);

    long removeKeyIfAbsent(int key, long value);

    long getIfAbsentPut(int key, long value);

    long getIfAbsentPut(int key, LongFunction0 function);

    long getIfAbsentPutWithKey(int key, IntToLongFunction function);

    <P> long getIfAbsentPutWith(int key, LongFunction<? super P> function, P parameter);

    long updateValue(int key, long initialValueIfAbsent, LongToLongFunction function);

    MutableIntLongMap select(IntLongPredicate predicate);

    MutableIntLongMap reject(IntLongPredicate predicate);

    MutableIntLongMap withKeyValue(int key, long value);

    MutableIntLongMap withoutKey(int key);

    MutableIntLongMap withoutAllKeys(IntIterable keys);

    MutableIntLongMap asUnmodifiable();

    MutableIntLongMap asSynchronized();


    long addToValue(int key, long toBeAdded);
}
