/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.ShortBooleanPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableShortBooleanMap extends ShortBooleanMap, MutableBooleanValuesMap
{
    void put(short key, boolean value);

    void putAll(ShortBooleanMap map);

    void removeKey(short key);

    void remove(short key);

    boolean removeKeyIfAbsent(short key, boolean value);

    boolean getIfAbsentPut(short key, boolean value);

    boolean getIfAbsentPut(short key, BooleanFunction0 function);

    boolean getIfAbsentPutWithKey(short key, ShortToBooleanFunction function);

    <P> boolean getIfAbsentPutWith(short key, BooleanFunction<? super P> function, P parameter);

    boolean updateValue(short key, boolean initialValueIfAbsent, BooleanToBooleanFunction function);

    MutableShortBooleanMap select(ShortBooleanPredicate predicate);

    MutableShortBooleanMap reject(ShortBooleanPredicate predicate);

    MutableShortBooleanMap withKeyValue(short key, boolean value);

    MutableShortBooleanMap withoutKey(short key);

    MutableShortBooleanMap withoutAllKeys(ShortIterable keys);

    MutableShortBooleanMap asUnmodifiable();

    MutableShortBooleanMap asSynchronized();
}
