/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatFloatPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.FloatFloatMap;
import com.gs.collections.api.map.primitive.ImmutableFloatFloatMap;
import com.gs.collections.api.map.primitive.MutableFloatFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.FloatFloatPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedFloatFloatProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.map.mutable.primitive.FloatFloatHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableFloatFloatHashMap
implements ImmutableFloatFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableFloatFloatMap delegate;

    ImmutableFloatFloatHashMap(FloatFloatMap delegate) {
        this.delegate = new FloatFloatHashMap(delegate);
    }

    public float get(float key) {
        return this.delegate.get(key);
    }

    public float getIfAbsent(float key, float ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(float key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(float key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(float value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatFloatProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<FloatFloatPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableFloatFloatMap select(FloatFloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatFloatMap reject(FloatFloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableFloatFloatMap toImmutable() {
        return this;
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator((FloatIterator)this.delegate.floatIterator());
    }

    public void forEach(FloatProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum() {
        return this.delegate.sum();
    }

    public float max() {
        return this.delegate.max();
    }

    public float maxIfEmpty(float defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public float min() {
        return this.delegate.min();
    }

    public float minIfEmpty(float defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public float[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableFloatList toSortedList() {
        return this.delegate.toSortedList();
    }

    public float[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(float value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableFloatList toList() {
        return this.delegate.toList();
    }

    public MutableFloatSet toSet() {
        return this.delegate.toSet();
    }

    public MutableFloatBag toBag() {
        return this.delegate.toBag();
    }

    public LazyFloatIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableFloatFloatMap newWithKeyValue(float key, float value) {
        FloatFloatHashMap map = new FloatFloatHashMap(this.size() + 1);
        map.putAll((FloatFloatMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableFloatFloatMap newWithoutKey(float key) {
        FloatFloatHashMap map = new FloatFloatHashMap(this.size());
        map.putAll((FloatFloatMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableFloatFloatMap newWithoutAllKeys(FloatIterable keys) {
        FloatFloatHashMap map = new FloatFloatHashMap(this.size());
        map.putAll((FloatFloatMap)this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(this.delegate.keySet());
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableFloatFloatMapSerializationProxy((FloatFloatMap)this);
    }

    protected static class ImmutableFloatFloatMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private FloatFloatMap map;

        public ImmutableFloatFloatMapSerializationProxy() {
        }

        protected ImmutableFloatFloatMapSerializationProxy(FloatFloatMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((FloatFloatProcedure)new CheckedFloatFloatProcedure(){

                    public void safeValue(float key, float value) throws IOException {
                        out.writeFloat(key);
                        out.writeFloat(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            FloatFloatHashMap deserializedMap = new FloatFloatHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readFloat(), in.readFloat());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

