/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.tuple;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.tuple.Tuples;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractImmutableEntry<K, V>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final KeyFunction<?> TO_KEY = new KeyFunction();
    private static final ValueFunction<?> TO_VALUE = new ValueFunction();
    private static final PairFunction<?, ?> TO_PAIR = new PairFunction();
    protected final K key;
    protected final V value;

    public AbstractImmutableEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K> Function<Map.Entry<K, ?>, K> getKeyFunction() {
        return TO_KEY;
    }

    public static <V> Function<Map.Entry<?, V>, V> getValueFunction() {
        return TO_VALUE;
    }

    public static <K, V> Function<Map.Entry<K, V>, Pair<K, V>> getPairFunction() {
        return TO_PAIR;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException("Cannot call setValue() on " + this.getClass().getSimpleName());
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PairFunction<K, V>
    implements Function<Map.Entry<K, V>, Pair<K, V>> {
        private static final long serialVersionUID = 1L;

        private PairFunction() {
        }

        public Pair<K, V> valueOf(Map.Entry<K, V> entry) {
            return Tuples.pairFrom(entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueFunction<V>
    implements Function<Map.Entry<?, V>, V> {
        private static final long serialVersionUID = 1L;

        private ValueFunction() {
        }

        public V valueOf(Map.Entry<?, V> entry) {
            return entry.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyFunction<K>
    implements Function<Map.Entry<K, ?>, K> {
        private static final long serialVersionUID = 1L;

        private KeyFunction() {
        }

        public K valueOf(Map.Entry<K, ?> entry) {
            return entry.getKey();
        }
    }
}

