/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.lazy.primitive.AbstractLazyLongIterable;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import java.util.Arrays;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectLongIterable<T>
extends AbstractLazyLongIterable {
    private final LazyIterable<T> iterable;
    private final LongFunction<? super T> function;
    private final LongFunctionToProcedure<T> longFunctionToProcedure;

    public CollectLongIterable(LazyIterable<T> adapted, LongFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.longFunctionToProcedure = new LongFunctionToProcedure(function);
    }

    public LongIterator longIterator() {
        return new LongIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectLongIterable.this.iterable.iterator();
            }

            public long next() {
                return CollectLongIterable.this.function.longValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    public void forEach(LongProcedure procedure) {
        this.iterable.forEachWith(this.longFunctionToProcedure, (Object)procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(final LongPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectLongIterable.this.function.longValueOf(each));
            }
        });
    }

    @Override
    public boolean anySatisfy(final LongPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectLongIterable.this.function.longValueOf(each));
            }
        });
    }

    @Override
    public boolean allSatisfy(final LongPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectLongIterable.this.function.longValueOf(each));
            }
        });
    }

    @Override
    public boolean noneSatisfy(final LongPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return !predicate.accept(CollectLongIterable.this.function.longValueOf(each));
            }
        });
    }

    @Override
    public long[] toArray() {
        final long[] array = new long[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                array[index] = CollectLongIterable.this.function.longValueOf(each);
            }
        });
        return array;
    }

    @Override
    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    @Override
    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this);
    }

    @Override
    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongIterable)this);
    }

    @Override
    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LongFunctionToProcedure<T>
    implements Procedure2<T, LongProcedure> {
        private static final long serialVersionUID = 1L;
        private final LongFunction<? super T> function;

        private LongFunctionToProcedure(LongFunction<? super T> function) {
            this.function = function;
        }

        public void value(T each, LongProcedure procedure) {
            procedure.value(this.function.longValueOf(each));
        }
    }
}

