/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.list;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.multimap.list.ImmutableListMultimap;
import com.gs.collections.api.multimap.list.MutableListMultimap;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.AbstractMutableMultimap;
import com.gs.collections.impl.multimap.bag.HashBagMultimap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.multimap.list.ImmutableListMultimapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableListMultimap<K, V>
extends AbstractMutableMultimap<K, V, MutableList<V>>
implements MutableListMultimap<K, V> {
    protected AbstractMutableListMultimap() {
    }

    protected AbstractMutableListMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    protected AbstractMutableListMultimap(Iterable<Pair<K, V>> inputIterable) {
        super(inputIterable);
    }

    protected AbstractMutableListMultimap(int size) {
        super(size);
    }

    public MutableListMultimap<K, V> toMutable() {
        return new FastListMultimap(this);
    }

    public ImmutableListMultimap<K, V> toImmutable() {
        final UnifiedMap map = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, MutableList<V>>(){

            public void value(K key, MutableList<V> list) {
                map.put(key, (Object)list.toImmutable());
            }
        });
        return new ImmutableListMultimapImpl(map);
    }

    public <K2, V2> HashBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap());
    }

    public <V2> FastListMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, FastListMultimap.newMultimap());
    }
}

