/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.parallel;

import com.gs.collections.api.bag.Bag;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.ListIterable;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.set.SetIterable;
import com.gs.collections.api.set.sorted.SortedSetIterable;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.list.mutable.CompositeFastList;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.parallel.AbstractProcedureCombiner;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.utility.internal.DefaultSpeciesNewStrategy;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformerBasedCombiner<V, T, BT extends Procedure<T>>
extends AbstractProcedureCombiner<BT> {
    private static final long serialVersionUID = 1L;
    protected final Collection<V> result;

    protected AbstractTransformerBasedCombiner(boolean useCombineOne, Collection<V> targetCollection, Iterable<T> iterable, int initialCapacity) {
        super(useCombineOne);
        this.result = this.initializeResult(iterable, targetCollection, initialCapacity);
    }

    protected Collection<V> initializeResult(Iterable<T> sourceIterable, Collection<V> targetCollection, int initialCapacity) {
        if (targetCollection != null) {
            return targetCollection;
        }
        if (sourceIterable instanceof ListIterable) {
            return new CompositeFastList();
        }
        if (sourceIterable instanceof SortedSetIterable) {
            return FastList.newList();
        }
        if (sourceIterable instanceof SetIterable) {
            this.setCombineOne(true);
            return UnifiedSet.newSet(initialCapacity);
        }
        if (sourceIterable instanceof Bag || sourceIterable instanceof MapIterable) {
            return HashBag.newBag(initialCapacity);
        }
        return this.createResultForCollection(sourceIterable, initialCapacity);
    }

    private Collection<V> createResultForCollection(Iterable<T> sourceCollection, int initialCapacity) {
        if (sourceCollection instanceof Collection) {
            return DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)sourceCollection, initialCapacity);
        }
        return FastList.newList(initialCapacity);
    }

    public Collection<V> getResult() {
        return this.result;
    }
}

