/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableBooleanStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableBooleanStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableBooleanArrayStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableBooleanEmptyStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableBooleanSingletonStack;

public class ImmutableBooleanStackFactoryImpl
implements ImmutableBooleanStackFactory {
    public ImmutableBooleanStack empty() {
        return ImmutableBooleanEmptyStack.INSTANCE;
    }

    public ImmutableBooleanStack of() {
        return this.empty();
    }

    public ImmutableBooleanStack with() {
        return this.empty();
    }

    public ImmutableBooleanStack of(boolean one) {
        return this.with(one);
    }

    public ImmutableBooleanStack with(boolean one) {
        return new ImmutableBooleanSingletonStack(one);
    }

    public ImmutableBooleanStack of(boolean ... items) {
        return this.with(items);
    }

    public ImmutableBooleanStack with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableBooleanArrayStack.newStackWith(items);
    }

    public ImmutableBooleanStack ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    public ImmutableBooleanStack withAll(BooleanIterable items) {
        if (items instanceof ImmutableBooleanStack) {
            return (ImmutableBooleanStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableBooleanStack ofAllReversed(BooleanIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableBooleanStack withAllReversed(BooleanIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableBooleanArrayStack.newStackFromTopToBottom(items);
    }
}

