/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommandLine {
    public static String[] parse(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        CommandLine.appendParsedCommandArgs(arrayList, Arrays.asList(stringArray));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void appendParsedCommandArgs(List<String> list, List<String> list2) throws IOException {
        for (String string : list2) {
            if (string.length() > 1 && string.charAt(0) == '@') {
                if ((string = string.substring(1)).charAt(0) == '@') {
                    list.add(string);
                    continue;
                }
                CommandLine.loadCmdFile(string, list);
                continue;
            }
            list.add(string);
        }
    }

    public static List<String> parse(String string, List<String> list) throws IOException, UnmatchedQuote {
        ArrayList<String> arrayList = new ArrayList<String>();
        CommandLine.appendParsedEnvVariables(arrayList, string);
        arrayList.addAll(list);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        CommandLine.appendParsedCommandArgs(arrayList2, arrayList);
        return arrayList2;
    }

    public static String[] parse(String string, String[] stringArray) throws IOException, UnmatchedQuote {
        List<String> list = CommandLine.parse(string, Arrays.asList(stringArray));
        return list.toArray(new String[list.size()]);
    }

    private static void loadCmdFile(String string, List<String> list) throws IOException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(string, new String[0]));){
            String string2;
            Tokenizer tokenizer = new Tokenizer(bufferedReader);
            while ((string2 = tokenizer.nextToken()) != null) {
                list.add(string2);
            }
        }
    }

    private static void appendParsedEnvVariables(List<String> list, String string) throws UnmatchedQuote {
        if (string == null) {
            return;
        }
        String string2 = System.getenv(string);
        if (string2 == null || string2.trim().isEmpty()) {
            return;
        }
        int n = string2.length();
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        char c = '\u0000';
        block4: while (n2 < n) {
            char c2 = string2.charAt(n2);
            switch (c2) {
                case '\"': 
                case '\'': {
                    if (c == '\u0000') {
                        c = c2;
                    } else if (c == c2) {
                        c = '\u0000';
                    } else {
                        stringBuilder.append(c2);
                    }
                    ++n2;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (c == '\u0000') {
                        list.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        while (c2 == '\f' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ') {
                            if (++n2 >= n) break block4;
                            c2 = string2.charAt(n2);
                        }
                        continue block4;
                    }
                }
                default: {
                    stringBuilder.append(c2);
                    ++n2;
                    continue block4;
                }
            }
        }
        if (stringBuilder.length() != 0) {
            list.add(stringBuilder.toString());
        }
        if (c != '\u0000') {
            throw new UnmatchedQuote(string);
        }
    }

    public static class UnmatchedQuote
    extends Exception {
        private static final long serialVersionUID = 0L;
        public final String variableName;

        UnmatchedQuote(String string) {
            this.variableName = string;
        }
    }

    public static class Tokenizer {
        private final Reader in;
        private int ch;

        public Tokenizer(Reader reader) throws IOException {
            this.in = reader;
            this.ch = reader.read();
        }

        public String nextToken() throws IOException {
            this.skipWhite();
            if (this.ch == -1) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            char c = '\u0000';
            block13: while (this.ch != -1) {
                switch (this.ch) {
                    case 9: 
                    case 12: 
                    case 32: {
                        if (c == '\u0000') {
                            return stringBuilder.toString();
                        }
                        stringBuilder.append((char)this.ch);
                        break;
                    }
                    case 10: 
                    case 13: {
                        return stringBuilder.toString();
                    }
                    case 34: 
                    case 39: {
                        if (c == '\u0000') {
                            c = (char)this.ch;
                            break;
                        }
                        if (c == this.ch) {
                            c = '\u0000';
                            break;
                        }
                        stringBuilder.append((char)this.ch);
                        break;
                    }
                    case 92: {
                        if (c != '\u0000') {
                            this.ch = this.in.read();
                            switch (this.ch) {
                                case 10: 
                                case 13: {
                                    while (this.ch == 32 || this.ch == 10 || this.ch == 13 || this.ch == 9 || this.ch == 12) {
                                        this.ch = this.in.read();
                                    }
                                    continue block13;
                                }
                                case 110: {
                                    this.ch = 10;
                                    break;
                                }
                                case 114: {
                                    this.ch = 13;
                                    break;
                                }
                                case 116: {
                                    this.ch = 9;
                                    break;
                                }
                                case 102: {
                                    this.ch = 12;
                                }
                            }
                        }
                        stringBuilder.append((char)this.ch);
                        break;
                    }
                    default: {
                        stringBuilder.append((char)this.ch);
                    }
                }
                this.ch = this.in.read();
            }
            return stringBuilder.toString();
        }

        void skipWhite() throws IOException {
            while (this.ch != -1) {
                switch (this.ch) {
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: {
                        break;
                    }
                    case 35: {
                        this.ch = this.in.read();
                        while (this.ch != 10 && this.ch != 13 && this.ch != -1) {
                            this.ch = this.in.read();
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.ch = this.in.read();
            }
        }
    }
}

