/*
 * Decompiled with CFR 0.152.
 */
package jaitools.imageutils;

import com.vividsolutions.jts.awt.ShapeReader;
import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import jaitools.imageutils.PixelCoordType;
import jaitools.jts.CoordinateSequence2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.LinkedList;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;

public class ROIGeometry
extends ROI {
    private static boolean DEFAULT_ROIGEOMETRY_ANTIALISING = true;
    private static boolean DEFAULT_ROIGEOMETRY_USEFIXEDPRECISION = true;
    private boolean useAntialiasing = DEFAULT_ROIGEOMETRY_ANTIALISING;
    private boolean useFixedPrecision = DEFAULT_ROIGEOMETRY_USEFIXEDPRECISION;
    private static final long serialVersionUID = 1L;
    private static final AffineTransformation Y_INVERSION = new AffineTransformation(1.0, 0.0, 0.0, 0.0, -1.0, 0.0);
    private static final String UNSUPPORTED_ROI_TYPE = "The argument be either an ROIGeometry or an ROIShape";
    private final PreparedGeometry theGeom;
    private PlanarImage roiImage;
    private final GeometryFactory geomFactory;
    private static final double tolerance = 1.0;
    private static final PrecisionModel PRECISION = new PrecisionModel(1.0);
    private static final GeometryFactory PRECISE_FACTORY = new GeometryFactory(PRECISION);
    private final CoordinateSequence2D testPointCS;
    private final Point testPoint;
    private final CoordinateSequence2D testRectCS;
    private final Polygon testRect;
    private final PixelCoordType coordType;
    private final double delta;

    public ROIGeometry(Geometry geom) {
        this(geom, PixelCoordType.CORNER, DEFAULT_ROIGEOMETRY_ANTIALISING, DEFAULT_ROIGEOMETRY_USEFIXEDPRECISION);
    }

    public ROIGeometry(Geometry geom, boolean useFixedPrecision) {
        this(geom, PixelCoordType.CORNER, DEFAULT_ROIGEOMETRY_ANTIALISING, useFixedPrecision);
    }

    public ROIGeometry(Geometry geom, PixelCoordType coordType) {
        this(geom, coordType, DEFAULT_ROIGEOMETRY_ANTIALISING, DEFAULT_ROIGEOMETRY_USEFIXEDPRECISION);
    }

    public ROIGeometry(Geometry geom, PixelCoordType coordType, boolean antiAliasing, boolean useFixedPrecision) {
        if (geom == null) {
            throw new IllegalArgumentException("geom must not be null");
        }
        if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon)) {
            throw new IllegalArgumentException("geom must be a Polygon, MultiPolygon or null");
        }
        this.useFixedPrecision = useFixedPrecision;
        Geometry cloned = null;
        if (useFixedPrecision) {
            Coordinate[] coords;
            this.geomFactory = PRECISE_FACTORY;
            cloned = this.geomFactory.createGeometry(geom);
            Coordinate[] arr$ = coords = cloned.getCoordinates();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Coordinate coord;
                Coordinate cc1 = coord = arr$[i$];
                PRECISION.makePrecise(cc1);
            }
            cloned.normalize();
        } else {
            this.geomFactory = new GeometryFactory();
            cloned = (Geometry)geom.clone();
        }
        this.theGeom = PreparedGeometryFactory.prepare((Geometry)cloned);
        this.testPointCS = new CoordinateSequence2D(1);
        this.testPoint = this.geomFactory.createPoint((CoordinateSequence)this.testPointCS);
        this.testRectCS = new CoordinateSequence2D(5);
        this.testRect = this.geomFactory.createPolygon(this.geomFactory.createLinearRing((CoordinateSequence)this.testRectCS), null);
        this.coordType = coordType;
        this.delta = coordType == PixelCoordType.CENTER ? 0.5 : 0.0;
    }

    public ROI add(ROI roi) {
        Geometry geom = this.getGeometry(roi);
        if (geom != null) {
            Geometry union = geom.union(this.theGeom.getGeometry());
            return new ROIGeometry(union);
        }
        throw new UnsupportedOperationException(UNSUPPORTED_ROI_TYPE);
    }

    public boolean contains(java.awt.Point p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public boolean contains(double x, double y) {
        this.testPointCS.setX(0, x + this.delta);
        this.testPointCS.setY(0, y + this.delta);
        this.testPoint.geometryChanged();
        return this.theGeom.contains((Geometry)this.testPoint);
    }

    public boolean contains(Rectangle rect) {
        return this.contains(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(Rectangle2D rect) {
        return this.contains(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(int x, int y, int w, int h) {
        return this.contains((double)x, (double)y, (double)w, (double)h);
    }

    public boolean contains(double x, double y, double w, double h) {
        this.setTestRect(x, y, w, h);
        return this.theGeom.contains((Geometry)this.testRect);
    }

    public ROI exclusiveOr(ROI roi) {
        Geometry geom = this.getGeometry(roi);
        if (geom != null) {
            return new ROIGeometry(this.theGeom.getGeometry().symDifference(geom));
        }
        throw new UnsupportedOperationException(UNSUPPORTED_ROI_TYPE);
    }

    public int[][] getAsBitmask(int x, int y, int width, int height, int[][] mask) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PlanarImage getAsImage() {
        if (this.roiImage == null) {
            Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
            int x = (int)Math.floor(env.getMinX());
            int y = (int)Math.floor(env.getMinY());
            int w = (int)Math.ceil(env.getWidth());
            int h = (int)Math.ceil(env.getHeight());
            ParameterBlockJAI pb = new ParameterBlockJAI("VectorBinarize");
            pb.setParameter("minx", x);
            pb.setParameter("miny", y);
            pb.setParameter("width", w);
            pb.setParameter("height", h);
            pb.setParameter("geometry", (Object)this.theGeom);
            pb.setParameter("coordtype", (Object)this.coordType);
            pb.setParameter("antiAliasing", this.useAntialiasing);
            this.roiImage = JAI.create((String)"VectorBinarize", (ParameterBlock)pb);
        }
        return this.roiImage;
    }

    public LinkedList getAsRectangleList(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected LinkedList getAsRectangleList(int x, int y, int width, int height, boolean mergeRectangles) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Shape getAsShape() {
        return new ShapeWriter().toShape(this.theGeom.getGeometry());
    }

    public Geometry getAsGeometry() {
        return this.theGeom.getGeometry();
    }

    public Rectangle getBounds() {
        Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
        return new Rectangle((int)env.getMinX(), (int)env.getMinY(), (int)env.getWidth(), (int)env.getHeight());
    }

    public Rectangle2D getBounds2D() {
        Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
        return new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight());
    }

    public int getThreshold() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ROI intersect(ROI roi) {
        Geometry geom = this.getGeometry(roi);
        if (geom != null) {
            Geometry intersect = geom.intersection(this.theGeom.getGeometry());
            return new ROIGeometry(intersect);
        }
        throw new UnsupportedOperationException(UNSUPPORTED_ROI_TYPE);
    }

    private Geometry getGeometry(ROI roi) {
        if (roi instanceof ROIGeometry) {
            return ((ROIGeometry)roi).getAsGeometry();
        }
        if (roi instanceof ROIShape) {
            Shape shape = ((ROIShape)roi).getAsShape();
            Geometry geom = ShapeReader.read((Shape)shape, (double)0.0, (GeometryFactory)this.geomFactory);
            geom.apply((CoordinateSequenceFilter)Y_INVERSION);
            return geom;
        }
        return null;
    }

    public boolean intersects(Rectangle rect) {
        this.setTestRect(rect.x, rect.y, rect.width, rect.height);
        return this.theGeom.intersects((Geometry)this.testRect);
    }

    public boolean intersects(Rectangle2D rect) {
        this.setTestRect(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
        return this.theGeom.intersects((Geometry)this.testRect);
    }

    public boolean intersects(int x, int y, int w, int h) {
        this.setTestRect(x, y, w, h);
        return this.theGeom.intersects((Geometry)this.testRect);
    }

    public boolean intersects(double x, double y, double w, double h) {
        this.setTestRect(x, y, w, h);
        return this.theGeom.intersects((Geometry)this.testRect);
    }

    public ROI performImageOp(RenderedImageFactory RIF, ParameterBlock paramBlock, int sourceIndex, RenderingHints renderHints) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ROI performImageOp(String name, ParameterBlock paramBlock, int sourceIndex, RenderingHints renderHints) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setThreshold(int threshold) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ROI subtract(ROI roi) {
        Geometry geom = this.getGeometry(roi);
        if (geom != null) {
            return new ROIGeometry(this.theGeom.getGeometry().difference(geom));
        }
        throw new UnsupportedOperationException(UNSUPPORTED_ROI_TYPE);
    }

    public ROI transform(AffineTransform at, Interpolation interp) {
        return this.transform(at);
    }

    public ROI transform(AffineTransform at) {
        Geometry cloned = (Geometry)this.theGeom.getGeometry().clone();
        cloned.apply((CoordinateSequenceFilter)new AffineTransformation(at.getScaleX(), at.getShearX(), at.getTranslateX(), at.getShearY(), at.getScaleY(), at.getTranslateY()));
        if (this.useFixedPrecision) {
            Coordinate[] coords;
            Geometry fixed = PRECISE_FACTORY.createGeometry(cloned);
            Coordinate[] arr$ = coords = fixed.getCoordinates();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Coordinate coord;
                Coordinate precise = coord = arr$[i$];
                PRECISION.makePrecise(precise);
            }
            cloned = fixed;
        }
        return new ROIGeometry(cloned);
    }

    private void setTestRect(double x, double y, double w, double h) {
        this.testRectCS.setXY(0, x + this.delta, y + this.delta);
        this.testRectCS.setXY(1, x + this.delta, y + h - this.delta);
        this.testRectCS.setXY(2, x + w - this.delta, y + h - this.delta);
        this.testRectCS.setXY(3, x + w - this.delta, y + this.delta);
        this.testRectCS.setXY(4, x + this.delta, y + this.delta);
        this.testRect.geometryChanged();
    }
}

