/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javacc.GrammarDirectoryScanner;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JavaCC;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractJavaCCMojo
extends AbstractMojo {
    private MavenProject project;
    private Collection<File> nonGeneratedSourceRoots;
    private String jdkVersion;
    private Integer lookAhead;
    private Integer choiceAmbiguityCheck;
    private Integer otherAmbiguityCheck;
    private Boolean debugParser;
    private Boolean debugLookAhead;
    private Boolean debugTokenManager;
    private Boolean errorReporting;
    private Boolean javaUnicodeEscape;
    private Boolean unicodeInput;
    private Boolean ignoreCase;
    private Boolean commonTokenAction;
    private Boolean userTokenManager;
    private Boolean userCharStream;
    private Boolean buildParser;
    private Boolean buildTokenManager;
    private Boolean tokenManagerUsesParser;
    private String tokenExtends;
    private String tokenFactory;
    private Boolean sanityCheck;
    private Boolean forceLaCheck;
    private Boolean cacheTokens;
    private Boolean keepLineColumn;
    private Boolean supportClassVisibilityPublic;
    private String grammarEncoding;
    private String outputEncoding;
    private String javaTemplateType;

    protected String getGrammarEncoding() {
        return this.grammarEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding;
    }

    protected String getJdkVersion() {
        return this.jdkVersion;
    }

    protected String getJavaTemplateType() {
        return this.javaTemplateType;
    }

    protected abstract File getSourceDirectory();

    protected abstract String[] getIncludes();

    protected abstract String[] getExcludes();

    protected abstract File getOutputDirectory();

    protected abstract int getStaleMillis();

    protected abstract File[] getCompileSourceRoots();

    protected String getParserPackage() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        GrammarInfo[] grammarInfoArray2;
        GrammarInfo[] grammarInfoArray = this.scanForGrammars();
        if (grammarInfoArray == null) {
            this.getLog().info((CharSequence)("Skipping non-existing source directory: " + this.getSourceDirectory()));
            return;
        }
        if (grammarInfoArray.length <= 0) {
            this.getLog().info((CharSequence)"Skipping - all parsers are up to date");
        } else {
            void file;
            this.determineNonGeneratedSourceRoots();
            if (StringUtils.isEmpty((String)this.grammarEncoding)) {
                this.getLog().warn((CharSequence)"File encoding for grammars has not been configured, using platform default encoding, i.e. build is platform dependent!");
            }
            if (StringUtils.isEmpty((String)this.outputEncoding)) {
                this.getLog().warn((CharSequence)"File encoding for output has not been configured, defaulting to UTF-8!");
            }
            grammarInfoArray2 = grammarInfoArray;
            int n = grammarInfoArray2.length;
            boolean bl = false;
            while (file < n) {
                GrammarInfo grammarInfo = grammarInfoArray2[file];
                this.processGrammar(grammarInfo);
                ++file;
            }
            this.getLog().info((CharSequence)("Processed " + grammarInfoArray.length + " grammar" + (grammarInfoArray.length != 1 ? "s" : "")));
        }
        grammarInfoArray2 = new LinkedHashSet(Arrays.asList(this.getCompileSourceRoots()));
        for (File file : grammarInfoArray2) {
            this.addSourceRoot(file);
        }
    }

    protected abstract void processGrammar(GrammarInfo var1) throws MojoExecutionException, MojoFailureException;

    private GrammarInfo[] scanForGrammars() throws MojoExecutionException {
        GrammarInfo[] grammarInfoArray;
        if (!this.getSourceDirectory().isDirectory()) {
            return null;
        }
        this.getLog().debug((CharSequence)("Scanning for grammars: " + this.getSourceDirectory()));
        try {
            GrammarDirectoryScanner grammarDirectoryScanner = new GrammarDirectoryScanner();
            grammarDirectoryScanner.setSourceDirectory(this.getSourceDirectory());
            grammarDirectoryScanner.setIncludes(this.getIncludes());
            grammarDirectoryScanner.setExcludes(this.getExcludes());
            grammarDirectoryScanner.setOutputDirectory(this.getOutputDirectory());
            grammarDirectoryScanner.setParserPackage(this.getParserPackage());
            grammarDirectoryScanner.setStaleMillis(this.getStaleMillis());
            grammarDirectoryScanner.scan();
            grammarInfoArray = grammarDirectoryScanner.getIncludedGrammars();
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to scan for grammars: " + this.getSourceDirectory(), exception);
        }
        this.getLog().debug((CharSequence)("Found grammars: " + Arrays.asList(grammarInfoArray)));
        return grammarInfoArray;
    }

    protected File getTempDirectory() {
        return new File(this.project.getBuild().getDirectory(), "javacc-" + System.currentTimeMillis());
    }

    protected void deleteTempDirectory(File file) {
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException iOException) {
            this.getLog().warn((CharSequence)("Failed to delete temporary directory: " + file), (Throwable)iOException);
        }
    }

    protected void copyGrammarOutput(File file, String string, File file2, String string2) throws MojoExecutionException {
        try {
            List list = FileUtils.getFiles((File)file2, (String)"*.java", null);
            for (File file3 : list) {
                String string3 = "";
                if (string.length() > 0) {
                    string3 = string.replace('.', '/') + '/';
                }
                string3 = string3 + file3.getName();
                File file4 = new File(file, string3);
                File file5 = this.findSourceFile(string3);
                boolean bl = false;
                if (string2 != null && file5 != null) {
                    bl = string2.startsWith("!") ? !SelectorUtils.match((String)string2.substring(1), (String)file3.getName()) : SelectorUtils.match((String)string2, (String)file3.getName());
                }
                if (file5 == null || bl && file5.equals(file4)) {
                    this.getLog().debug((CharSequence)("Copying generated file: " + string3));
                    try {
                        FileUtils.copyFile((File)file3, (File)file4);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new MojoExecutionException("Failed to copy generated source file to output directory:" + file3 + " -> " + file4, (Exception)iOException);
                    }
                }
                this.getLog().debug((CharSequence)("Skipping customized file: " + string3));
            }
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to copy generated source files", (Exception)iOException);
        }
    }

    private void determineNonGeneratedSourceRoots() throws MojoExecutionException {
        this.nonGeneratedSourceRoots = new LinkedHashSet<File>();
        try {
            String string = new File(this.project.getBuild().getDirectory()).getCanonicalPath() + File.separator;
            List list = this.project.getCompileSourceRoots();
            for (String string2 : list) {
                String string3;
                File file = new File(string2);
                if (!file.isAbsolute()) {
                    file = new File(this.project.getBasedir(), file.getPath());
                }
                if (!(string3 = file.getCanonicalPath()).startsWith(string)) {
                    this.nonGeneratedSourceRoots.add(file);
                    this.getLog().debug((CharSequence)("Non-generated compile source root: " + file));
                    continue;
                }
                this.getLog().debug((CharSequence)("Generated compile source root: " + file));
            }
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to determine non-generated source roots", (Exception)iOException);
        }
    }

    private File findSourceFile(String string) {
        Collection<File> collection = this.nonGeneratedSourceRoots;
        for (File file : collection) {
            File file2 = new File(file, string);
            if (!file2.exists()) continue;
            return file2;
        }
        return null;
    }

    protected boolean isSourceRoot(File file) {
        return this.nonGeneratedSourceRoots.contains(file);
    }

    private void addSourceRoot(File file) {
        if (this.project != null) {
            this.getLog().debug((CharSequence)("Adding compile source root: " + file));
            this.project.addCompileSourceRoot(file.getAbsolutePath());
        }
    }

    protected JavaCC newJavaCC() {
        JavaCC javaCC = new JavaCC();
        javaCC.setLog(this.getLog());
        javaCC.setGrammarEncoding(this.grammarEncoding);
        javaCC.setOutputEncoding(this.outputEncoding);
        javaCC.setJdkVersion(this.jdkVersion);
        javaCC.setBuildParser(this.buildParser);
        javaCC.setBuildTokenManager(this.buildTokenManager);
        javaCC.setCacheTokens(this.cacheTokens);
        javaCC.setChoiceAmbiguityCheck(this.choiceAmbiguityCheck);
        javaCC.setCommonTokenAction(this.commonTokenAction);
        javaCC.setDebugLookAhead(this.debugLookAhead);
        javaCC.setDebugParser(this.debugParser);
        javaCC.setDebugTokenManager(this.debugTokenManager);
        javaCC.setErrorReporting(this.errorReporting);
        javaCC.setForceLaCheck(this.forceLaCheck);
        javaCC.setIgnoreCase(this.ignoreCase);
        javaCC.setJavaUnicodeEscape(this.javaUnicodeEscape);
        javaCC.setKeepLineColumn(this.keepLineColumn);
        javaCC.setLookAhead(this.lookAhead);
        javaCC.setOtherAmbiguityCheck(this.otherAmbiguityCheck);
        javaCC.setSanityCheck(this.sanityCheck);
        javaCC.setTokenManagerUsesParser(this.tokenManagerUsesParser);
        javaCC.setTokenExtends(this.tokenExtends);
        javaCC.setTokenFactory(this.tokenFactory);
        javaCC.setUnicodeInput(this.unicodeInput);
        javaCC.setUserCharStream(this.userCharStream);
        javaCC.setUserTokenManager(this.userTokenManager);
        javaCC.setSupportClassVisibilityPublic(this.supportClassVisibilityPublic);
        javaCC.setJavaTemplateType(this.javaTemplateType);
        return javaCC;
    }
}

