/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus.implementation;

import com.microsoft.windowsazure.core.UserAgentFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterRequestAdapter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.exception.ServiceExceptionFactory;
import com.microsoft.windowsazure.services.servicebus.implementation.WrapAccessTokenResult;
import com.microsoft.windowsazure.services.servicebus.implementation.WrapContract;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.representation.Form;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WrapRestProxy
implements WrapContract {
    private Client channel;
    private static Log log = LogFactory.getLog(WrapContract.class);

    @Inject
    public WrapRestProxy(Client channel, UserAgentFilter userAgentFilter) {
        this.channel = channel;
        this.channel.addFilter((ClientFilter)new ClientFilterRequestAdapter((ServiceRequestFilter)userAgentFilter));
    }

    @Override
    public WrapAccessTokenResult wrapAccessToken(String uri, String name, String password, String scope) throws ServiceException {
        Form responseForm;
        Form requestForm = new Form();
        requestForm.add("wrap_name", name);
        requestForm.add("wrap_password", password);
        requestForm.add("wrap_scope", scope);
        try {
            responseForm = (Form)((WebResource.Builder)this.channel.resource(uri).accept(new String[]{"application/x-www-form-urlencoded"}).type("application/x-www-form-urlencoded")).post(Form.class, (Object)requestForm);
        }
        catch (UniformInterfaceException e) {
            log.warn((Object)"WRAP server returned error acquiring access_token", (Throwable)e);
            throw ServiceExceptionFactory.process((String)"WRAP", (ServiceException)new ServiceException("WRAP server returned error acquiring access_token", (Throwable)e));
        }
        WrapAccessTokenResult response = new WrapAccessTokenResult();
        response.setAccessToken(responseForm.getFirst("wrap_access_token"));
        String expiresIn = responseForm.getFirst("wrap_access_token_expires_in");
        response.setExpiresIn(Long.parseLong(expiresIn));
        return response;
    }
}

