/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.impl;

import com.netflix.eventbus.impl.AgeBatchingQueue;
import com.netflix.eventbus.impl.EventBusImpl;
import com.netflix.eventbus.impl.SizeAndAgeBatchingQueue;
import com.netflix.eventbus.spi.SubscriberConfigProvider;
import com.netflix.eventbus.utils.EventBusUtils;
import java.lang.reflect.Method;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

class DefaultConsumerQueueSupplier
implements EventBusImpl.ConsumerQueueSupplier {
    DefaultConsumerQueueSupplier() {
    }

    @Override
    public EventBusImpl.ConsumerQueueSupplier.ConsumerQueue get(Method subscriber, final SubscriberConfigProvider.SubscriberConfig subscriberConfig, final AtomicLong queueSizeCounter) {
        switch (subscriberConfig.getBatchingStrategy()) {
            case Age: {
                return new AgeBatchingQueue(subscriber, subscriberConfig, queueSizeCounter);
            }
            case SizeOrAge: {
                return new SizeAndAgeBatchingQueue(subscriber, subscriberConfig, queueSizeCounter);
            }
        }
        return new EventBusImpl.ConsumerQueueSupplier.ConsumerQueue(){
            private LinkedBlockingQueue delegate;
            {
                this.delegate = new LinkedBlockingQueue(EventBusUtils.getQueueSize(subscriberConfig));
            }

            @Override
            public boolean offer(Object event) {
                boolean offered = this.delegate.offer(event);
                if (offered) {
                    queueSizeCounter.incrementAndGet();
                }
                return offered;
            }

            @Override
            public Object nonBlockingTake() {
                Object retrievedItem = this.delegate.poll();
                if (null != retrievedItem) {
                    queueSizeCounter.decrementAndGet();
                }
                return retrievedItem;
            }

            @Override
            public Object blockingTake() throws InterruptedException {
                Object retrieved = this.delegate.take();
                queueSizeCounter.decrementAndGet();
                return retrieved;
            }

            @Override
            public void clear() {
                this.delegate.clear();
                queueSizeCounter.set(0L);
            }
        };
    }
}

