/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.client.ReferralInfo;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPSearchResults
implements Externalizable {
    private Vector entries;
    private int entryCount;
    private int entryIndex;
    private Vector references;
    private int referenceCount;
    private int referenceIndex;
    private int batchSize;
    private boolean completed = false;
    private LDAPControl[] controls = null;
    private LDAPSearchQueue queue;
    private static Object nameLock = new Object();
    private static int resultsNum = 0;
    private String name;
    private LDAPConnection conn;
    private LDAPSearchConstraints cons;
    private ArrayList referralConn = null;

    public LDAPSearchResults() {
    }

    LDAPSearchResults(LDAPConnection lDAPConnection, LDAPSearchQueue lDAPSearchQueue, LDAPSearchConstraints lDAPSearchConstraints) {
        this.conn = lDAPConnection;
        this.cons = lDAPSearchConstraints;
        int n = lDAPSearchConstraints.getBatchSize();
        int n2 = n == 0 ? 64 : 0;
        this.entries = new Vector(n == 0 ? 64 : n, n2);
        this.entryCount = 0;
        this.entryIndex = 0;
        this.references = new Vector(5, 5);
        this.referenceCount = 0;
        this.referenceIndex = 0;
        this.queue = lDAPSearchQueue;
        this.batchSize = n == 0 ? Integer.MAX_VALUE : n;
    }

    public int getCount() {
        int n = this.queue.getMessageAgent().getCount();
        return this.entryCount - this.entryIndex + this.referenceCount - this.referenceIndex + n;
    }

    public LDAPControl[] getResponseControls() {
        return this.controls;
    }

    public boolean hasMore() {
        boolean bl = false;
        if (this.entryIndex < this.entryCount || this.referenceIndex < this.referenceCount) {
            bl = true;
        } else if (!this.completed) {
            this.resetVectors();
            bl = this.entryIndex < this.entryCount || this.referenceIndex < this.referenceCount;
        }
        return bl;
    }

    private void resetVectors() {
        if (this.completed) {
            return;
        }
        if (this.referenceIndex != 0 && this.referenceIndex >= this.referenceCount) {
            this.references.setSize(0);
            this.referenceCount = 0;
            this.referenceIndex = 0;
        }
        if (this.entryIndex != 0 && this.entryIndex >= this.entryCount) {
            this.entries.setSize(0);
            this.entryCount = 0;
            this.entryIndex = 0;
        }
        if (this.referenceIndex == 0 && this.referenceCount == 0 && this.entryIndex == 0 && this.entryCount == 0) {
            this.completed = this.getBatchOfResults();
        }
    }

    public LDAPEntry next() throws LDAPException {
        if (this.completed && this.entryIndex >= this.entryCount && this.referenceIndex >= this.referenceCount) {
            throw new NoSuchElementException("LDAPSearchResults.next() no more results");
        }
        this.resetVectors();
        Object var1_1 = null;
        if (this.referenceIndex < this.referenceCount) {
            String[] stringArray = (String[])this.references.elementAt(this.referenceIndex++);
            LDAPReferralException lDAPReferralException = new LDAPReferralException("REFERENCE_NOFOLLOW");
            lDAPReferralException.setReferrals(stringArray);
            throw lDAPReferralException;
        }
        if (this.entryIndex < this.entryCount) {
            if ((var1_1 = this.entries.elementAt(this.entryIndex++)) instanceof LDAPResponse) {
                LDAPResponse lDAPResponse;
                ReferralInfo referralInfo;
                if (((LDAPResponse)var1_1).hasException() && (referralInfo = (lDAPResponse = (LDAPResponse)var1_1).getActiveReferral()) != null) {
                    LDAPReferralException lDAPReferralException = new LDAPReferralException("REFERENCE_ERROR", lDAPResponse.getException());
                    lDAPReferralException.setReferrals(referralInfo.getReferralList());
                    lDAPReferralException.setFailedReferral(referralInfo.getReferralUrl().toString());
                    throw lDAPReferralException;
                }
                ((LDAPResponse)var1_1).chkResultCode();
            } else if (var1_1 instanceof LDAPException) {
                throw (LDAPException)var1_1;
            }
        } else {
            throw new LDAPException("REFERRAL_LOCAL", new Object[]{"next"}, 82, (String)null);
        }
        return var1_1;
    }

    private boolean getBatchOfResults() {
        int n = 0;
        while (n < this.batchSize) {
            try {
                Object object;
                LDAPMessage lDAPMessage = this.queue.getResponse();
                if (lDAPMessage != null) {
                    int[] nArray;
                    String[] stringArray;
                    object = lDAPMessage.getControls();
                    if (object != null) {
                        this.controls = object;
                    }
                    if (lDAPMessage instanceof LDAPSearchResult) {
                        stringArray = ((LDAPSearchResult)lDAPMessage).getEntry();
                        this.entries.addElement(stringArray);
                        ++n;
                        ++this.entryCount;
                        continue;
                    }
                    if (lDAPMessage instanceof LDAPSearchResultReference) {
                        stringArray = ((LDAPSearchResultReference)lDAPMessage).getReferrals();
                        if (this.cons.getReferralFollowing()) {
                            this.referralConn = this.conn.chaseReferral(this.queue, this.cons, lDAPMessage, stringArray, 0, true, this.referralConn);
                            continue;
                        }
                        this.references.addElement(stringArray);
                        ++this.referenceCount;
                        continue;
                    }
                    stringArray = (LDAPResponse)lDAPMessage;
                    int n2 = stringArray.getResultCode();
                    if (stringArray.hasException()) {
                        n2 = 91;
                    }
                    if (n2 == 10 && this.cons.getReferralFollowing()) {
                        this.referralConn = this.conn.chaseReferral(this.queue, this.cons, (LDAPMessage)stringArray, stringArray.getReferrals(), 0, false, this.referralConn);
                    } else if (n2 != 0) {
                        this.entries.addElement(stringArray);
                        ++this.entryCount;
                    }
                    if ((nArray = this.queue.getMessageIDs()).length != 0) continue;
                    this.conn.releaseReferralConnections(this.referralConn);
                    return true;
                }
                object = new LDAPException(null, 85, null);
                this.entries.addElement(object);
                break;
            }
            catch (LDAPException lDAPException) {
                this.entries.addElement(lDAPException);
            }
        }
        return false;
    }

    void abandon() {
        this.queue.getMessageAgent().abandonAll();
        this.resetVectors();
        this.completed = true;
    }

    private void writeAttribute(LDAPAttribute lDAPAttribute, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("<attr name=\"");
        stringBuffer.append(lDAPAttribute.getName());
        stringBuffer.append("\">");
        String[] stringArray = lDAPAttribute.getStringValueArray();
        byte[][] byArray = lDAPAttribute.getByteValueArray();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(ValueXMLhandler.newLine(3));
            if (Base64.isValidUTF8(byArray[i], false)) {
                stringBuffer.append("<value><![CDATA[");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("]]></value>");
                continue;
            }
            stringBuffer.append("<value xsi:type=\"xsd:base64Binary\"><![CDATA[");
            stringBuffer.append(Base64.encode(byArray[i]));
            stringBuffer.append("]]></value>");
        }
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("</attr>");
    }

    private void writeControl(LDAPControl lDAPControl, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("<control type=\"");
        stringBuffer.append(lDAPControl.getID());
        stringBuffer.append("\" criticality=\"" + lDAPControl.isCritical() + "\"");
        byte[] byArray = lDAPControl.getValue();
        if (byArray == null) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
            stringBuffer.append(ValueXMLhandler.newLine(2));
            stringBuffer.append("<controlValue xsi:type=\"xsd:base64Binary\">");
            stringBuffer.append(Base64.encode(byArray));
            stringBuffer.append("</controlValue>");
            stringBuffer.append(ValueXMLhandler.newLine(1));
            stringBuffer.append("</control>");
        }
        stringBuffer.append(ValueXMLhandler.newLine(0));
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPSearchResults.getTopXMLHandler("LDAPSearchResults", null));
        return (Vector)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            Vector ldapEntries = new Vector();

            protected void initHandler() {
                this.setchildelement(LDAPSearchResults.getXMLEntryHandler("LDAPEntry", this));
                this.setchildelement(LDAPSearchResults.getXMLControlHandler("control", this));
            }

            protected void endElement() {
                this.setObject(this.ldapEntries);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("LDAPEntry")) {
                    this.ldapEntries.add(object);
                } else if (string.equals("control")) {
                    this.ldapEntries.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLControlHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String oid;
            boolean critical;
            byte[] controlvalue;

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler("controlValue", this));
            }

            protected void endElement() {
                LDAPControl lDAPControl = new LDAPControl(this.oid, this.critical, this.controlvalue);
                this.setObject(lDAPControl);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("controlValue")) {
                    this.controlvalue = (byte[])object;
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.oid = attributes.getValue("type");
                if (this.oid == null) {
                    throw new SAXException("type is mandatory for a Control");
                }
                this.critical = "true".equalsIgnoreCase(attributes.getValue("criticality"));
            }
        };
    }

    static LDAPXMLHandler getXMLEntryHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String dn;
            ArrayList valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.addAll((Collection)this.valuelist);
                LDAPEntry lDAPEntry = new LDAPEntry(this.dn, lDAPAttributeSet);
                this.setObject(lDAPEntry);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.dn = attributes.getValue("dn");
                if (this.dn == null) {
                    throw new SAXException("invalid entry Tag, dn is mandatory element: ");
                }
            }
        };
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string = "";
        string = string + "*************************************************************************\n";
        string = string + "** The encrypted data above and below is the Class definition and  ******\n";
        string = string + "** other data specific to Java Serialization Protocol. The data  ********\n";
        string = string + "** which is of most application specific interest is as follows... ******\n";
        string = string + "*************************************************************************\n";
        string = string + "****************** Start of application data ****************************\n";
        string = string + "*************************************************************************\n";
        stringBuffer.append(string);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("<LDAPSearchResults>");
        stringBuffer.append(ValueXMLhandler.newLine(1));
        while (this.hasMore()) {
            object = null;
            try {
                object = this.next();
            }
            catch (LDAPException lDAPException) {
                continue;
            }
            stringBuffer.append("<LDAPEntry dn=\"");
            stringBuffer.append(((LDAPEntry)object).getDN());
            stringBuffer.append("\">");
            Iterator iterator = ((LDAPEntry)object).getAttributeSet().iterator();
            while (iterator.hasNext()) {
                this.writeAttribute((LDAPAttribute)iterator.next(), stringBuffer);
            }
            stringBuffer.append(ValueXMLhandler.newLine(1));
            stringBuffer.append("</LDAPEntry>");
            stringBuffer.append(ValueXMLhandler.newLine(1));
        }
        object = this.getResponseControls();
        if (object != null) {
            for (int i = 0; i < ((LDAPControl[])object).length; ++i) {
                this.writeControl((LDAPControl)object[i], stringBuffer);
            }
        }
        stringBuffer.append("</LDAPSearchResults>");
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string2 = "";
        string2 = string2 + "*************************************************************************\n";
        string2 = string2 + "****************** End of application data ******************************\n";
        string2 = string2 + "*************************************************************************\n";
        stringBuffer.append(string2);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        objectOutput.write(stringBuffer.toString().getBytes());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = (ObjectInputStream)objectInput;
        StringBuffer stringBuffer = new StringBuffer();
        while (objectInputStream.available() != 0) {
            stringBuffer.append((char)objectInputStream.read());
        }
        String string = stringBuffer.toString();
        string = string.substring(string.indexOf(60), string.lastIndexOf(62) + 1);
        StringBuffer stringBuffer2 = new StringBuffer();
        ValueXMLhandler.parseInput(string, stringBuffer2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuffer2.toString().getBytes()));
        Vector vector = (Vector)LDAPSearchResults.readDSML(bufferedInputStream);
        Vector<LDAPEntry> vector2 = new Vector<LDAPEntry>();
        ArrayList<LDAPControl> arrayList = new ArrayList<LDAPControl>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof LDAPEntry) {
                vector2.add((LDAPEntry)e);
                continue;
            }
            if (!(e instanceof LDAPControl)) continue;
            arrayList.add((LDAPControl)e);
        }
        this.entries = vector2;
        this.controls = new LDAPControl[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.controls[i] = (LDAPControl)arrayList.get(i);
        }
        vector = null;
        vector2 = null;
        arrayList = null;
    }

    public Vector getDeSerializedEntries() {
        return this.entries;
    }

    public LDAPControl[] getDeSerializedControls() {
        return this.controls;
    }
}

